package com.ulcjava.base.application.tabletree;


	/**
	* <code>ULCTableTreeColumnModel</code> manages the table tree's
	* columns.
<p>
<b>Features</b>
<ul>
<li>Register
	* <code>IColumnModelListener</code>s to handle events like add, remove, or move
	* of a column.
<li>Column selection within <code>ULCTableTreeColumnModel</code>
	* is managed by an instance of <code>ULCListSelectionModel</code>.
<li>Most of
	* the API is duplicated in the <code>ULCTableTree</code>, so the developer
	* usually won't need to access
<code>ULCTableColumnModel</code> directly.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCListSelectionModel
	* @see		com.ulcjava.base.application.AbstractColumnModel
	* @see		com.ulcjava.base.application.event.IColumnModelListener
	**/
 public class ULCTableTreeColumnModel extends com.ulcjava.base.application.AbstractColumnModel
{

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Appends <code>column</code> to the end of the table tree columns list.
	*
	* @param column 		 the <code>ULCTableTreeColumn</code> to be added
	**/
	 public void addColumn(com.ulcjava.base.application.tabletree.ULCTableTreeColumn column)
	{
	}


	/**
	* Deletes <code>column</code> from the table tree columns list.
	*
	* @param column 		 the <code>ULCTableTreeColumn</code> to be removed
	**/
	 public void removeColumn(com.ulcjava.base.application.tabletree.ULCTableTreeColumn column)
	{
	}


	/**
	* Returns the table tree column at the specified <code>columnIndex</code>.
	*
	* @param columnIndex 		 the index of the desired column
	* @return		the <code>ULCTableTreeColumn</code> object for the column at <code>columnIndex</code>
	**/
	 public com.ulcjava.base.application.tabletree.ULCTableTreeColumn getColumn(int columnIndex)
	{
		return null;
	}


	/**
	* Returns the index of the column in the table tree.
	*
	* @param column 		 the column object
	* @return		the index of the column in the table tree
	**/
	 public int getColumnIndex(com.ulcjava.base.application.tabletree.ULCTableTreeColumn column)
	{
		return 0;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTableTreeColumnModelDispatcher extends AbstractColumnModelDispatcher
{


}
}