package com.ulcjava.base.application.tree;


	/**
	* The <code>AbstractTreeModel</code> class provides a default implementation for
	* some of the methods in the <code>ITreeModel</code>
interface. In general you
	* subclass <code>AbstractTreeModel</code> to implement your own tree
	* model.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>AbstractTreeModel</code>
	* class manages the handling of tree model listeners.
<li>To notify the tree
	* model listeners that data in the tree model has changed, use the following
	* convenience methods:
<ul>
<li><code>nodeChanged()</code> when a single node
	* has been changed
<li><code>nodesChange()</code> when some children of a node
	* have been changed
<li><code>nodesWereInserted()</code> when new children have
	* been inserted at some node
<li><code>nodesWereRemoved()</code> when children
	* of a node have been deleted
<li><code>nodeStructureChanged()</code> when the
	* children nodes of some node have been (structurally) changed
</ul>
<li>In
	* manyapplications, tree model implementations are read-only and will not
	* support writing back to the model. For this reason a
default implementation
	* ofthe <code>valueForPathChanged()</code> method is provided that throws
	* an
<code>UnsupportedOperationException</code>.
</ul>
<b>Examples</b>
<p>
</p>
T
	* he following example shows how to implement a custom tree model adapting the
	* server file system. When the application itself changes the
data source (e.g.
	* setting the root, creating or deleting files) the tree model has to notify
	* thetree model listeners.

<pre>
private class FileTreeModel extends
	* AbstractTreeModel {
private File fRoot;

public FileTreeModel(File root)
	* {
fRoot = root;
}

public Object getRoot() {
return fRoot;
}

public Object
	* getChild(Object parent, int index) {
File parentFile = (File)parent;
return
	* parentFile.listFiles()[index];
}

public int getChildCount(Object parent)
	* {
File parentFile = (File)parent;
return !isLeaf(parent) ?
	* parentFile.listFiles().length : 0;
}

public boolean isLeaf(Object node)
	* {
File file = (File)node;
return !file.isDirectory();
}

public int
	* getIndexOfChild(Object parent, Object child) {
File parentFile =
	* (File)parent;return
	* Arrays.asList(parentFile.listFiles()).indexOf(child);
}

public void
	* setRoot(TreePath newRoot) {
fRoot =
	* (File)newRoot.getLastPathComponent();
nodeStructureChanged(new
	* TreePath(fRoot));
}

public void delete(TreePath path) {
TreePath parentPath
	* =path.getParentPath();
File parent =
	* (File)parentPath.getLastPathComponent();
File deletedFile =
	* (File)path.getLastPathComponent();
int deletedFileIndex =
	* getIndexOfChild(parent, deletedFile);
if (!deletedFile.delete()) {
throw new
	* IllegalArgumentException(&quot;could not delete file: &quot;
+
	* deletedFile);
}nodesWereRemoved(parentPath, new int[] {deletedFileIndex},
new
	* Object[] {deletedFile});
}

public void create(TreePath parentPath, String
	* filename) {
File parent = (File)parentPath.getLastPathComponent();
File
	* createdFile = new File(parent, filename);
try {
if
	* (!createdFile.createNewFile()) {
throw new
	* IllegalArgumentException(&quot;filealready exists: &quot;
+ createdFile);
}
}
	* catch (IOException e) {
throw new IllegalArgumentException(&quot;could not
	* create file: &quot;
+ createdFile);
}
int createdFileIndex =
	* getIndexOfChild(parent, createdFile);
nodesWereInserted(parentPath, new int[]
	* {createdFileIndex});
}
}
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCTree
	* @see		ITreeModel
	**/
 public  abstract class AbstractTreeModel extends java.lang.Object implements java.io.Serializable, com.ulcjava.base.application.tree.ITreeModel
{


	/**
	* Creates a new abstract tree model.
	*
	**/
	 protected AbstractTreeModel()
	{
		 super();
	}

	 public void addTreeModelListener(com.ulcjava.base.application.event.ITreeModelListener listener)
	{
	}


	/**
	* Invoke this method after you have changed a node.
	*
	* @param path 		 the path to the node you have changed
	**/
	 public void nodeChanged(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Invoke this method after you have changed children of a parent node.
	*
	* @param parentPath 		 the path to the parent node
	* @param childIndices 		 the indices of the changed children
	**/
	 public void nodesChanged(com.ulcjava.base.application.tree.TreePath parentPath, int[] childIndices)
	{
	}


	/**
	* Invoke this method after you have changed the children structure in a node.
	*
	* @param path 		 the path to the node
	**/
	 public void nodeStructureChanged(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Invoke this method after you have inserted new children into a parent node.
	*
	* @param parentPath 		 the path to the parent node
	* @param childIndices 		 the indices of the newly inserted children nodes
	**/
	 public void nodesWereInserted(com.ulcjava.base.application.tree.TreePath parentPath, int[] childIndices)
	{
	}


	/**
	* Invoke this method after you have removed existing children form a parent node.
	*
	* @param parentPath 		 the path to the parent node
	* @param childIndices 		 the indices of the removed children nodes
	* @param removedChildren 		 the removed children nodes
	**/
	 public void nodesWereRemoved(com.ulcjava.base.application.tree.TreePath parentPath, int[] childIndices, java.lang.Object[] removedChildren)
	{
	}

	 public void removeTreeModelListener(com.ulcjava.base.application.event.ITreeModelListener listener)
	{
	}


	/**
	* Returns an array of all the tree model listeners registered on this model.
	*
	* @return		all of this model's <code>ITreeModelListener</code>s or an empty array if no tree model listeners are currently registered
	* @see		#addTreeModelListener(ITreeModelListener)
	* @see		#removeTreeModelListener(ITreeModelListener)
	**/
	 public com.ulcjava.base.application.event.ITreeModelListener[] getTreeModelListeners()
	{
		return null;
	}

	 public void valueForPathChanged(com.ulcjava.base.application.tree.TreePath path, java.lang.Object value)
	{
	}


}