package com.ulcjava.base.application.tree;


	/**
	* <code>ITreeCellEditor</code> interface provides components to edit tree
	* nodes.
<p>
<b>Features</b>
<ul>
<li>Allows definition of a component to be
	* used for editing a tree node.
<li>The component can be chosen based on value,
	* selection, expanded, leaf and focus states.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.table.ITableCellEditor
	**/
 public interface ITreeCellEditor
{


	/**
	* Return the editor component that is used to edit a tree node.
	*
	* @param tree 		 the tree of the node to edit
	* @param value 		 the value of the node to edit
	* @param selected 		 true if the node is selected, false otherwise
	* @param expanded 		 true if the node is expanded, false otherwise
	* @param leaf 		 true if the node is a leaf, false otherwise
	* @return		the editor component that is used to edit a tree node
	**/
	com.ulcjava.base.application.IEditorComponent getTreeCellEditorComponent(com.ulcjava.base.application.ULCTree tree, java.lang.Object value, boolean selected, boolean expanded, boolean leaf);

}