package com.ulcjava.base.application.tree;


	/**
	* <code>ULCTreeSelectionModel</code> manages selection in
	* <code>ULCTree</code>.
<p>
<b>Features</b>
<ul>
<li><code>ULCTreeSelectionModel<
	* /code> notifies its listeners when path selection changes, in order to be
	* informed about all changes in
selected rows, one must listen also to
	* expansionevents in the corresponding <code>ULCTree</code>.
<li>It supports
	* three selection modes:
<li><code>SINGLE_TREE_SELECTION</code> - only one item
	* can be selected at a time, selecting a new one will clear the previous
	* selection
<li><code>CONTIGUOUS_TREE_SELECTION</code> - selection range must
	* becontiguous, i.e., there can be no unselected nodes between any two
selected
	* nodes. If a change the selection would make it non-contiguous, necessary
	* itemsare deselected to keep the selection contiguous
and be consistent with
	* applied change.
<li><code>DISCONTIGUOUS_TREE_SELECTION</code> - any number of
	* items may be a valid selection
<li><code>ULCTreeSelectionModel</code> may act
	* as an enabler. It will enable the depending components when selection is not
	* empty and
disable them when it is empty.
</ul>
<b>Examples</b>
<p>
The
	* examplebelow illustrates how to set a selection mode on a tree and how to
	* create a button, which becomes enabled only if the
selection in the tree is
	* not
	* empty.

<pre>
tree.getSelectionModel().setSelectionMode(
ULCTreeSelectionModel.
	* SINGLE_TREE_SELECTION);
deleteFileButton.setEnabler(tree.getSelectionModel());
<
	* /pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCTree
	**/
 public class ULCTreeSelectionModel extends com.ulcjava.base.application.ULCProxy implements com.ulcjava.base.application.enabler.IEnabler, com.ulcjava.base.application.enabler.IHasChangedSource
{

	/**
	* Selection can only contain one path at a time.
	*
	**/
	 public  final  static int SINGLE_TREE_SELECTION = 0;

	/**
	* Selection can only be contiguous.
	*
	**/
	 public  final  static int CONTIGUOUS_TREE_SELECTION = 0;

	/**
	* Selection can contain any number of items that are not necessarily contiguous.
	*
	**/
	 public  final  static int DISCONTIGUOUS_TREE_SELECTION = 0;

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}

	 protected void updateSelection(int[][] selectionPaths)
	{
	}

	 public java.lang.String toString()
	{
		return null;
	}


	/**
	* Fires a tree selection changed event.
	*
	* @param treeSelectionEvent 		 the tree selection event to be distributed to all listeners
	* @ulc.extension		
	**/
	 protected void fireTreeSelectionChanged(com.ulcjava.base.application.event.TreeSelectionEvent treeSelectionEvent)
	{
	}


	/**
	* Creates a tree selection event.
<p>
</p>
<b>Note:</b> This method will be
	* called as part of a client-initiated event firing. </p>
	*
	* @return		a tree selection event with this <code>ULCProxy</code> object as the source
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.application.event.TreeSelectionEvent createTreeSelectionEvent()
	{
		return null;
	}


	/**
	* Dispatches a tree selection event to registered listeners via {@link
	* #dispatchEvent(String, String, java.util.EventObject)}.
Extension writers may
	* override this method to perform different or additional processing
	* actions.
<p>
</p>
<b>Note:</b> This method will be called as part of a
	* client-initiated event firing. </p>
	*
	* @param eventCategory 		 the event category for dispatching ({@link UlcEventCategories#TREE_SELECTION_EVENT_CATEGORY})
	* @param listenerMethodName 		 the name of the listener method to which to dispatch
	* @param eventObject 		 the event to be dispatched
	* @ulc.extension		
	* @see		#dispatchEvent(String, String, java.util.EventObject)
	**/
	 protected void processTreeSelectionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.TreeSelectionEvent eventObject)
	{
	}


	/**
	* Removes any paths that are part of the selection and that are descendants of
	* <code>path</code> when collapsing a tree.
	* If
<code>selectPathForDeselectedChildren</code> is true, and if any
	* descendantpath is selected, <code>path</code> will be added to the
selected
	* paths after collapsing the descendant paths.
	*
	* @param path 		 the parent path
	* @param selectPathForDeselectedChildren 		 the select path for deselected children flag
	**/
	 public void removeDescendantsFrom(com.ulcjava.base.application.tree.TreePath path, boolean selectPathForDeselectedChildren)
	{
	}


	/**
	* Removes the specified children (descendants) from a parent's path when they
	* getdeleted.
	*
	* @param parentPath 		 the parent path
	* @param children 		 the children to be removed
	**/
	 public void removeDescendantsFrom(com.ulcjava.base.application.tree.TreePath parentPath, java.lang.Object[] children)
	{
	}


	/**
	* Creates a new tree selection model with the specified row mapper and the
	* specified path converter.
	*
	* @param rowMapper 		 the row mapper
	* @param pathConverter 		 the path converter
	**/
	 public ULCTreeSelectionModel(com.ulcjava.base.server.IRowMapper rowMapper, com.ulcjava.base.server.IPathConverter pathConverter)
	{
		 super();
	}


	/**
	* Adds the specified path to the current selection.
	*
	* @param path 		 the path to add
	**/
	 public void addSelectionPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Adds each path in the array of paths to the current selection.
	*
	* @param paths 		 the paths to add
	**/
	 public void addSelectionPaths(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Adds a listener for tree selection events.
	*
	* @param listener 		 the tree selection listener to add
	**/
	 public void addTreeSelectionListener(com.ulcjava.base.application.event.ITreeSelectionListener listener)
	{
	}


	/**
	* Clears the selection.
	*
	**/
	 public void clearSelection()
	{
	}


	/**
	* Returns the number of selected pahts.
	*
	* @return		the number of selected pahts
	**/
	 public int getSelectionCount()
	{
		return 0;
	}


	/**
	* Returns the selection mode (SINGLE_SELECTION_MODE, CONTIGOUS_SELECTION_MODE,
	* orDISCONTIGUOUS_TREE_SELECTION).
	*
	* @return		the selection mode
	* @see		#setSelectionMode
	**/
	 public int getSelectionMode()
	{
		return 0;
	}


	/**
	* Returns the first selected path, or null if nothing is selected.
	*
	* @return		the first selected path, or null if nothing is selected
	**/
	 public com.ulcjava.base.application.tree.TreePath getSelectionPath()
	{
		return null;
	}


	/**
	* Returns the selected paths, or null if nothing is selected.
	*
	* @return		the selected paths, or null if nothing is selected
	**/
	 public com.ulcjava.base.application.tree.TreePath[] getSelectionPaths()
	{
		return null;
	}


	/**
	* Returns an array of all the <code>ITreeSelectionListener</code>s added to this
	* <code>ULCTreeSelectionModel</code>
	* with
<code>addTreeSelectionListener()</code>.
	*
	* @return		all <code>ITreeSelectionListener</code>s added or an empty array if no listeners have been added
	**/
	 public com.ulcjava.base.application.event.ITreeSelectionListener[] getTreeSelectionListeners()
	{
		return null;
	}


	/**
	* Returns true if the specified path is selected, false otherwise.
	*
	* @param path 		 the path
	* @return		true if the specified path is selected, false otherwise
	**/
	 public boolean isPathSelected(com.ulcjava.base.application.tree.TreePath path)
	{
		return false;
	}


	/**
	* Returns true if nothing is selected, false otherwise.
	*
	* @return		true if nothing is selected, false otherwise
	**/
	 public boolean isSelectionEmpty()
	{
		return false;
	}


	/**
	* Removes the specified path from the current selection.
	*
	* @param path 		 the path to remove
	**/
	 public void removeSelectionPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Removes the specified paths from the current selection.
	*
	* @param paths 		 the paths to remove
	**/
	 public void removeSelectionPaths(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Removes a listener for tree selection events.
	*
	* @param listener 		 the tree selection listener to remove
	**/
	 public void removeTreeSelectionListener(com.ulcjava.base.application.event.ITreeSelectionListener listener)
	{
	}


	/**
	* Updates this object's mapping from TreePaths to rows.
<p>
</p>
You do not
	* normally have to call this. ULC will invoke this for you.
	*
	**/
	 public void resetRowSelection()
	{
	}


	/**
	* Sets the selection mode (SINGLE_SELECTION_MODE, CONTIGOUS_SELECTION_MODE, or
	* DISCONTIGUOUS_TREE_SELECTION).
	*
	* @param selectionMode 		 the selection mode to set
	* @see		#getSelectionMode
	**/
	 public void setSelectionMode(int selectionMode)
	{
	}


	/**
	* Selects the specified path.
	*
	* @param path 		 the path to select
	**/
	 public void setSelectionPath(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Selects the specified paths.
	*
	* @param paths 		 the paths to select
	**/
	 public void setSelectionPaths(com.ulcjava.base.application.tree.TreePath[] paths)
	{
	}


	/**
	* Returns the last selected row.
	*
	* @return		index of the last selected row
	**/
	 public int getMaxSelectionRow()
	{
		return 0;
	}


	/**
	* Returns the first selected row.
	*
	* @return		index of the first selected row
	**/
	 public int getMinSelectionRow()
	{
		return 0;
	}


	/**
	* Get the listener class associated with the event category {@link
	* UlcEventCategories#TREE_SELECTION_EVENT_CATEGORY}.
	*
	* @return		The class object of {@link ITreeSelectionListener}.
	* @ulc.extension		
	**/
	 protected java.lang.Class getTreeSelectionListenerClass()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTreeSelectionModelDispatcher extends ULCProxyDispatcher
{

	 public  final void updateSelection(int[][] selectionPaths)
	{
	}

	 public  final com.ulcjava.base.application.event.TreeSelectionEvent createTreeSelectionEvent()
	{
		return null;
	}

	 public  final void processTreeSelectionEvent(java.lang.String eventCategory, java.lang.String listenerMethodName, com.ulcjava.base.application.event.TreeSelectionEvent eventObject)
	{
	}

	 public  final java.lang.Class getTreeSelectionListenerClass()
	{
		return null;
	}


}
}