package com.ulcjava.base.application.util;


	/**
	* <code>ApplicationLocal</code> is a utility class to simplify the handling of
	* application-wide variables. These variables differ from
their normal
	* counterparts in that each application instance that accesses one has its own
	* copy. In non-ULC applications one would usually
use a regular static variable
	* to implement an application wide
	* variable.
<p>
</p>
<b>Features</b>
<ul>
<li>The value of the
	* <code>ApplicationLocal</code> can be accessed via the <code>get()</code> and
	* <code>set()</code> methods.</li>
<li>A non-null initial value can be
	* specifiedby subclassing <code>ApplicationLocal</code> and overwriting the
	* initialValue() method.</li>
</ul>
<b>Examples</b>
<p>
</p>
The following
	* example shows how to declare an <code>ApplicationLocal</code>. The first one
	* is initialized to <code>null</code>, the
second one is implemented as
	* anonymous class so a non-null initial value can be specified.

<pre>
private
	* static ApplicationLocal sValue = new ApplicationLocal();
private static
	* ApplicationLocal sSpecialInitValue = new ApplicationLocal() {
protected
	* ObjectinitialValue() {
return &quot;initial&quot;;
}
};
</pre>

Accessing the
	* <code>ApplicationLocal</code>'s value is straightforward:

<pre>
ULCButton
	* setButton = new ULCButton(&quot;Set&quot;);
setButton.addActionListener(new
	* IActionListener() {
public void actionPerformed(ActionEvent event)
	* {
sSpecialInitValue.set(valueTextField.getText());
}
});
ULCButton getButton
	* =new ULCButton(&quot;Get&quot;);
getButton.addActionListener(new
	* IActionListener() {
public void actionPerformed(ActionEvent event)
	* {
valueTextField.setText(sSpecialInitValue.get().toString());
}
});
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ApplicationContext
	* @deprecated		ApplicationLocal will be removed from ULC because it cannot be made serializable. Use ApplicationContext.setAttribute() /
ApplicationContext.getAttribute() instead.
	**/
 public class ApplicationLocal extends java.lang.Object
{


	/**
	* Creates a new session local.
	*
	**/
	 public ApplicationLocal()
	{
		 super();
	}


	/**
	* Returns the initial value for this session local. The session local is
	* initialized to this value when a session accesses it for the
first time.
	*
	* @return		the initial value for this session local
	**/
	 protected java.lang.Object initialValue()
	{
		return null;
	}


	/**
	* Returns the value for the current session.
	*
	* @return		the value for the current session
	**/
	 public java.lang.Object get()
	{
		return null;
	}


	/**
	* Sets the value for the current session.
	*
	* @param value 		 the value
	**/
	 public void set(java.lang.Object value)
	{
	}


}