package com.ulcjava.base.application.util;


	/**
	* The <code>Cursor</code> class provides constants for the available cursors on
	* <code>ULCComponent</code> objects.
<p>
</p>
<b>Examples</b>
<p>
</p>
The
	* following code excerpt makes sure that the cursor changes to the text cursor
	* whenever it is positioned over the text field.

<pre>
ULCTextField field =
	* newULCTextField();
field.setCursor(Cursor.TEXT_CURSOR);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCComponent#setCursor(int)
	**/
 public class Cursor extends java.lang.Object
{

	/**
	* The default cursor type (used if no cursor is defined).
	*
	**/
	 public  final  static int DEFAULT_CURSOR = 0;

	/**
	* The crosshair cursor type.
	*
	**/
	 public  final  static int CROSSHAIR_CURSOR = 0;

	/**
	* The text cursor type.
	*
	**/
	 public  final  static int TEXT_CURSOR = 0;

	/**
	* The wait cursor type.
	*
	**/
	 public  final  static int WAIT_CURSOR = 0;

	/**
	* The south-west-resize cursor type.
	*
	**/
	 public  final  static int SW_RESIZE_CURSOR = 0;

	/**
	* The south-east-resize cursor type.
	*
	**/
	 public  final  static int SE_RESIZE_CURSOR = 0;

	/**
	* The north-west-resize cursor type.
	*
	**/
	 public  final  static int NW_RESIZE_CURSOR = 0;

	/**
	* The north-east-resize cursor type.
	*
	**/
	 public  final  static int NE_RESIZE_CURSOR = 0;

	/**
	* The north-resize cursor type.
	*
	**/
	 public  final  static int N_RESIZE_CURSOR = 0;

	/**
	* The south-resize cursor type.
	*
	**/
	 public  final  static int S_RESIZE_CURSOR = 0;

	/**
	* The west-resize cursor type.
	*
	**/
	 public  final  static int W_RESIZE_CURSOR = 0;

	/**
	* The east-resize cursor type.
	*
	**/
	 public  final  static int E_RESIZE_CURSOR = 0;

	/**
	* The hand cursor type.
	*
	**/
	 public  final  static int HAND_CURSOR = 0;

	/**
	* The move cursor type.
	*
	**/
	 public  final  static int MOVE_CURSOR = 0;

	 private Cursor()
	{
		 super();
	}


}