package com.ulcjava.base.application.util;


	/**
	* This utility class provides methods to convert text to html
	* strings.
<p>
</p>
<b>Features</b>
<ul>
<li>It surrounds the text with html
	* tags and converts new lines to a <code>br</code> tag
<li>It converts
	* <code>Color</code> and <code>Font</code> to a style tag
<li>It creates a
	* styletag out of the style of a component
<li>It may be used to display
	* multiline tooltips and multiline label
	* text.
</ul>
<p>
</p>
<b>Examples</b>
<p>
</p>
The first example converts text
	* with new lines in it to a html text:
<p>
</p>

<pre>
String htmlText =
	* HTMLUtilities.convertToHtml(&quot;First line\nSecond
	* Line\n&quot;);
</pre>

<p>
</p>
This results
	* in:
<p>
</p>

<pre>
&lt;html&gt;
First line&lt;br&gt;
Second
	* Line&lt;br&gt;
&lt;/html&gt;
</pre>

<p>
</p>
<p>
</p>
The following example
	* converts the string to html including a body style with this font and
	* color.
<p>
</p>

<pre>
String htmlWithStyleText =
	* HTMLUtilities.convertToHtmlWithStyle(new Font(
&quot;serif&quot;, Font.PLAIN,
	* 10), Color.red, &quot;First line\nSecond Line\n&quot;);
</pre>

<p>
</p>
This
	* results in:
<p>
</p>

<pre>
&lt;html&gt;
&lt;body style=&quot;color:#ff0000;
	* font-family:'serif';
font-size:10pt; font-style:normal;
	* font-weight:normal;&quot;&gt;
First line&lt;br&gt;
Second
	* Line&lt;br&gt;
&lt;/body&gt;
&lt;/html&gt;
</pre>

<p>
</p>
<p>
</p>
The
	* following example converts the multi line tool tip text to html and uses the
	* same style as the label:
<p>
</p>

<pre>
ULCLabel label = new
	* ULCLabel(&quot;label text&quot;);
label.setFont(new Font(&quot;serif&quot;,
	* Font.ITALIC,
	* 18));
label.setForeground(Color.green);
label.setToolTipText(HTMLUtilities.conv
	* ertToHtmlWithStyle(label,
&quot;Multi Line\nTool tip text\n&quot;));
</pre>
	*
	* @ulc.application		
	* @see		ULCComponent
	* @see		com.ulcjava.base.application.ULCLabel
	**/
 public class HTMLUtilities extends java.lang.Object
{

	 private HTMLUtilities()
	{
		 super();
	}


	/**
	* Utility method to convert plain string containing new line characters into
	* HTMLcode with the corresponding tags.
	*
	* @param text 		 the text to be reformated; <code>null</code> is equivalent to empty string
	* @return		string converted to HTML with new line converted to <br>
	**/
	 public  static java.lang.String convertToHtml(java.lang.String text)
	{
		return null;
	}


	/**
	* Utility method to convert plain string containing new line characters into
	* HTMLcode with the corresponding tags. Additionally this
method allows to set
	* aspecific style.
	*
	* @param font 		 the font for the style
	* @param color 		 the color for the style
	* @param text 		 the text to be reformated; <code>null</code> is equivalent to empty string
	* @return		converted to HTML with new line converted to <br>
with style
	**/
	 public  static java.lang.String convertToHtmlWithStyle(com.ulcjava.base.application.util.Font font, com.ulcjava.base.application.util.Color color, java.lang.String text)
	{
		return null;
	}


	/**
	* Utility method to convert plain string containing new line characters into
	* HTMLcode with the corresponding tags. Additionally this
method allows to pass
	* an <code>ULCComponent</code> from which the style (font, foreground) is taken.
	*
	* @param comp 		 the component used to determine the desired style
	* @param text 		 the text to be reformated; <code>null</code> is equivalent to empty string
	* @return		converted to HTML with new line converted to <br>
with style
	**/
	 public  static java.lang.String convertToHtmlWithStyle(com.ulcjava.base.application.ULCComponent comp, java.lang.String text)
	{
		return null;
	}


}