package com.ulcjava.base.application.util;


	/**
	* <code>HiearchyUtilities</code> provides various utility methods for
	* manipulating hierarchies of containers and
	* components.
<p>
</p>
<b>Features</b>
<ul>
<li>Set the enabled property on a
	* container and all its components and subcontainers.</li>
<li>Set the tool tip
	* text for a container and all its components and
	* subcontainers.</li>
</ul>
<b>Examples</b>
<p>
</p>
Instead of enabling/
	* disabling component by component with <HierarchyUtilities> this can be done
	* for all components (including
subcontainers and their components) held by a
	* container in one step:
<p>
</p>

<pre>
ULCFrame frame = new
	* ULCFrame();
ULCButton firstButton = new ULCButton(&quot;First
	* button&quot;);
ULCButton secondButton = new ULCButton(&quot;Second
	* button&quot;);
ULCButton thirdButton = new ULCButton(&quot;Third
	* button&quot;);
final ULCBoxPane pane = new
	* ULCBoxPane(true);
pane.add(firstButton);
pane.add(secondButton);
pane.add(third
	* Button);
frame.add(pane);
firstButton.addActionListener(new IActionListener()
	* {public void actionPerformed(ActionEvent event)
	* {
HierarchyUtilities.setEnabled(pane, false);
}
});
</pre>
	*
	* @ulc.application		
	**/
 public class HierarchyUtilities extends java.lang.Object
{

	 private HierarchyUtilities()
	{
		 super();
	}


	/**
	* Enables or disables all components for a container and its subcontainers.
	*
	* @param container 		 the container whose components will be disabled/ enabled
	* @param enabled 		 the new state (enabled/ disabled)
	**/
	 public  static void setEnabled(com.ulcjava.base.application.ULCContainer container, boolean enabled)
	{
	}


	/**
	* Sets or removes the tool tip text for a container, all subcontainers and their
	* components.
	*
	* @param container 		 the container on whose components will get a tool tip
	* @param toolTipText 		 the string which will be the tool tip
	**/
	 public  static void setToolTip(com.ulcjava.base.application.ULCContainer container, java.lang.String toolTipText)
	{
	}


}