package com.ulcjava.base.application.util;


	/**
	* Writing to a file located on the client machine is a three-step operation. The
	* first step is to initiate the client file upload by
calling the static
	* <code>storeFile()</code> method in the <code>ClientContext</code> class. This
	* method has to be provided with an
<code>IFileStoreHandler</code> argument. To
	* collect the data to be uploaded, the ULC framework invokes a hook in the
	* provided
<code>IFileLoadHandler</code> (step 2). Finally, another hook in
	* <code>IFileLoadHandler</code> is called when the upload has
finished.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ClientContext#storeFile(IFileStoreHandler, com.ulcjava.base.shared.FileChooserConfig,
com.ulcjava.base.application.ULCComponent)
	* @see		com.ulcjava.base.application.ClientContext#storeFile(IFileStoreHandler, String)
	* @see		DefaultFileStoreHandler
	**/
 public interface IFileStoreHandler
{

	/**
	* Indicates that the user cancelled the action.
	*
	**/
	 public  final  static int CANCELLED = 0;

	/**
	* Indicates that the action failed.
	*
	**/
	 public  final  static int FAILED = 0;


	/**
	* The content of the file has to be specified in this method.
	*
	* @param data 		 the output stream to fill with the content of the file to store
	* @throws		Exception if an error occurs during file preparation
	**/
	 public void prepareFile(java.io.OutputStream data)throws java.lang.Exception;

	/**
	* Invoked when the store file action was successful.
	*
	* @param filePath 		 the path of the stored file, or null when the client environment does not provide the file path information
	* @param fileName 		 the name of the stored file, or null when the client environment does not provide the file name information
	**/
	 public void onSuccess(java.lang.String filePath, java.lang.String fileName);

	/**
	* Invoked when the store file action failed.
	*
	* @param reason 		 the reason of the failue, one of the following values:
<ul>
<li>CANCELLED: the user cancelled the action
<li>FAILED: the action failed
</ul>
	* @param description 		 the description of the failure
	**/
	 public void onFailure(int reason, java.lang.String description);

}