package com.ulcjava.base.application.util;


	/**
	* A <code>KeyStroke</code> instance represents a key being typed on the
	* keyboard.<p>
</p>
<b>Features</b>
<ul>
<li>A <code>KeyStroke</code> is
	* definedby the character value of the key that must be pressed, the keyboard
	* modifiers (e.g., CTRL
key) required, and if the accelerator should be
	* triggered on key press or release.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCMenuItem
	**/
 public class KeyStroke extends java.lang.Object implements java.io.Serializable
{

	 private KeyStroke(char keyChar)
	{
		 super();
	}

	 private KeyStroke(int keyCode, int modifiers, boolean onKeyRelease)
	{
		 super();
	}

	 public boolean equals(java.lang.Object other)
	{
		return false;
	}

	 public int hashCode()
	{
		return 0;
	}

	 public java.lang.String toString()
	{
		return null;
	}


	/**
	* Returns an instance of KeyStroke built using the provided
	* parameters.
<p>
</p>
The key code can be given as one of the constants
	* definedin KeyEvent class.
<p>
</p>
The modifiers are a combination of
	* masks:
<ul>
<li>KeyEvent.SHIFT_MASK (1)
<li>KeyEvent.CTRL_MASK
	* (2)
<li>KeyEvent.META_MASK (4)
<li>KeyEvent.ALT_MASK (8)
</ul>
Those
	* constantscan be combined using bitwise OR.
	*
	* @param keyCode 		 an int specifying the numeric code for a keyboard key
	* @param modifiers 		 a mask representing a combination of the key modifiers
	* @param onKeyRelease 		 a boolean value. specifies whether the key is active when it is released
	* @return		an instance of KeyStroke built using the provided parameters
	* @see		KeyEvent
	* @deprecated		Use KeyStroke.getKeyStroke(int, int, boolean) instead.
	**/
	 public  static com.ulcjava.base.application.util.KeyStroke getAccelerator(int keyCode, int modifiers, boolean onKeyRelease)
	{
		return null;
	}


	/**
	* Returns an instance of KeyStroke built using the provided parameters.
	*
	* @param keyChar 		 a char specifying the keyboard key
	* @return		an instance of KeyStroke built using the provided parameters
	* @see		KeyEvent
	**/
	 public  static com.ulcjava.base.application.util.KeyStroke getKeyStroke(char keyChar)
	{
		return null;
	}


	/**
	* Returns an instance of KeyStroke built using the provided
	* parameters.
<p>
</p>
The key code can be given as one of the constants
	* definedin KeyEvent class.
<p>
</p>
The modifiers are a combination of
	* masks:
<ul>
<li>KeyEvent.SHIFT_MASK (1)
<li>KeyEvent.CTRL_MASK
	* (2)
<li>KeyEvent.META_MASK (4)
<li>KeyEvent.ALT_MASK (8)
</ul>
Those
	* constantscan be combined using bitwise OR.
	*
	* @param keyCode 		 an int specifying the numeric code for a keyboard key
	* @param modifiers 		 a mask representing a combination of the key modifiers
	* @return		an instance of KeyStroke built using the provided parameters
	* @see		KeyEvent
	**/
	 public  static com.ulcjava.base.application.util.KeyStroke getKeyStroke(int keyCode, int modifiers)
	{
		return null;
	}


	/**
	* Returns an instance of KeyStroke built using the provided
	* parameters.
<p>
</p>
The key code can be given as one of the constants
	* definedin KeyEvent class.
<p>
</p>
The modifiers are a combination of
	* masks:
<ul>
<li>KeyEvent.SHIFT_MASK (1)
<li>KeyEvent.CTRL_MASK
	* (2)
<li>KeyEvent.META_MASK (4)
<li>KeyEvent.ALT_MASK (8)
</ul>
Those
	* constantscan be combined using bitwise OR.
	*
	* @param keyCode 		 an int specifying the numeric code for a keyboard key
	* @param modifiers 		 a mask representing a combination of the key modifiers
	* @param onKeyRelease 		 a boolean value. specifies whether the key is active when it is released
	* @return		an instance of KeyStroke built using the provided parameters
	* @see		KeyEvent
	**/
	 public  static com.ulcjava.base.application.util.KeyStroke getKeyStroke(int keyCode, int modifiers, boolean onKeyRelease)
	{
		return null;
	}


	/**
	* Returns an instance of KeyStroke built using the provided
	* parameters.
<p>
</p>
The string must have the following syntax to be parsed
	* succesfully:

<pre>
&quot;&lt;modifiers&gt;* &lt;key&gt;&quot;
modifiers :=
	* shift | control | meta | alt
key := KeyEvent keycode name, i.e. the name
	* following &quot;VK_&quot;.
</pre>
	*
	* @param		keyStroke
	* @return		an instance of KeyStroke built using the provided parameters
	**/
	 public  static com.ulcjava.base.application.util.KeyStroke getKeyStroke(java.lang.String keyStroke)
	{
		return null;
	}


	/**
	* Returns an instance of KeyStroke built using the provided parameters.
	*
	* @param event 		 a key event to obtain the key stroke from
	* @return		an instance of KeyStroke built using the provided parameters
	**/
	 public  static com.ulcjava.base.application.util.KeyStroke getKeyStrokeForEvent(com.ulcjava.base.application.event.KeyEvent event)
	{
		return null;
	}


	/**
	* Returns the key char of this keyStroke.
	*
	* @return		the key char of this keyStroke
	**/
	 public char getKeyChar()
	{
		return 'a';
	}


	/**
	* Returns the key code of this keyStroke.
	*
	* @return		the key code of this keyStroke
	**/
	 public int getKeyCode()
	{
		return 0;
	}


	/**
	* Returns the modifier for this accelerator.
<p>
</p>
valid modifiers
	* are:
<ul>
<li><code>KeyEvent.SHIFT_MASK</code>
<li><code>KeyEvent.CTRL_MASK</co
	* de>
<li><code>KeyEvent.META_MASK</code>
<li><code>KeyEvent.ALT_MASK</code>
</ul>
	*
	* @return		the modifier for this accelerator.
	**/
	 public int getModifiers()
	{
		return 0;
	}


	/**
	* Returns true if the accelerator is triggered on key release event, false
	* otherwise.
	*
	* @return		true if the accelerator is triggered on key release event, false otherwise
	**/
	 public boolean isOnKeyRelease()
	{
		return false;
	}


}