package com.ulcjava.base.application.util;


	/**
	* The <code>SystemColor</code> class encapsulates the symbolic colors
	* representing the color of native GUI objects on a system. These
colors are
	* depending on the current color theme on the client
	* machine.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>SystemColor</code> class
	* provides constants for the available system colors to be used with
	* <code>ULCComponent</code>
objects.
<li>The effective RGB value of a system
	* color is depending on the current color theme on the client
	* machine.
</ul>
<p></p>
<b>Examples</b>
<p>
</p>
The following code snippet
	* shows how to use system colors to set a the background color of an
	* <code>ULCTextField</code> according to
the current desktop
	* color:

<pre>
ULCTextField field = new
	* ULCTextField(10);
field.setBackground(ClientContext.getSystemColor(SystemColor.
	* DESKTOP));
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCComponent
	**/
 public class SystemColor extends com.ulcjava.base.application.util.Color
{

	/**
	* The color currently set for the desktop.
	*
	**/
	 public  final  static java.lang.String desktop = null;

	/**
	* The color rendered for the window-title background of the currently active
	* window.
	*
	**/
	 public  final  static java.lang.String activeCaption = null;

	/**
	* The color rendered for the window-title text of the currently active window.
	*
	**/
	 public  final  static java.lang.String activeCaptionText = null;

	/**
	* The color rendered for the border around the currently active window.
	*
	**/
	 public  final  static java.lang.String activeCaptionBorder = null;

	/**
	* The color rendered for the window-title background of inactive windows.
	*
	**/
	 public  final  static java.lang.String inactiveCaption = null;

	/**
	* The color rendered for the window-title text of inactive windows.
	*
	**/
	 public  final  static java.lang.String inactiveCaptionText = null;

	/**
	* The color rendered for the border around inactive windows.
	*
	**/
	 public  final  static java.lang.String inactiveCaptionBorder = null;

	/**
	* The color rendered for the background of interior regions inside windows.
	*
	**/
	 public  final  static java.lang.String window = null;

	/**
	* The color rendered for the border around interior regions inside windows.
	*
	**/
	 public  final  static java.lang.String windowBorder = null;

	/**
	* The color rendered for text of interior regions inside windows.
	*
	**/
	 public  final  static java.lang.String windowText = null;

	/**
	* The color rendered for the background of menus.
	*
	**/
	 public  final  static java.lang.String menu = null;

	/**
	* The color rendered for the text of menus.
	*
	**/
	 public  final  static java.lang.String menuText = null;

	/**
	* The color rendered for the background of text control objects, such as
	* textfields and comboboxes.
	*
	**/
	 public  final  static java.lang.String text = null;

	/**
	* The color rendered for the text of text control objects, such as textfields
	* andcomboboxes.
	*
	**/
	 public  final  static java.lang.String textText = null;

	/**
	* The color rendered for the background of selected items, such as in menus,
	* comboboxes, and text.
	*
	**/
	 public  final  static java.lang.String textHighlight = null;

	/**
	* The color rendered for the text of selected items, such as in menus,
	* comboboxes, and text.
	*
	**/
	 public  final  static java.lang.String textHighlightText = null;

	/**
	* The color rendered for the text of inactive items, such as in menus.
	*
	**/
	 public  final  static java.lang.String textInactiveText = null;

	/**
	* The color rendered for the background of control panels and control objects,
	* such as buttons.
	*
	**/
	 public  final  static java.lang.String control = null;

	/**
	* The color rendered for the text of control panels and control objects, such as
	* buttons.
	*
	**/
	 public  final  static java.lang.String controlText = null;

	/**
	* The color rendered for light areas of 3D control objects, such as buttons.
	* Thiscolor is typically derived from the
<code>control</code> background color
	* to provide a 3D effect.
	*
	**/
	 public  final  static java.lang.String controlHighlight = null;

	/**
	* The color rendered for highlight areas of 3D control objects, such as buttons.
	* This color is typically derived from the
<code>control</code> background
	* colorto provide a 3D effect.
	*
	**/
	 public  final  static java.lang.String controlLtHighlight = null;

	/**
	* The color rendered for shadow areas of 3D control objects, such as buttons.
	* This color is typically derived from the
<code>control</code> background
	* colorto provide a 3D effect.
	*
	**/
	 public  final  static java.lang.String controlShadow = null;

	/**
	* The color rendered for dark shadow areas on 3D control objects, such as
	* buttons. This color is typically derived from the
<code>control</code>
	* background color to provide a 3D effect.
	*
	**/
	 public  final  static java.lang.String controlDkShadow = null;

	/**
	* The color rendered for the background of scrollbars.
	*
	**/
	 public  final  static java.lang.String scrollbar = null;

	/**
	* The color rendered for the background of tooltips.
	*
	**/
	 public  final  static java.lang.String info = null;

	/**
	* The color rendered for the text of tooltips.
	*
	**/
	 public  final  static java.lang.String infoText = null;

	 private SystemColor(java.lang.String key, int r, int g, int b, int a)
	{
		 super(0, 0, 0);
	}


	/**
	* Returns the system color for the specified key. If the key is a valid
	* identifier for the defined system colors, the
	* appropriate
<code>SystemColor</code> instance representing the system color
	* will be returned, otherwise an
<code>IllegalArgumentException</code> will be
	* thrown.
	*
	* @param key 		 the key of the system color
	* @return		the system color for the specified key
	* @throws		IllegalArgumentException if the specified key is not a valid system color identifier
	**/
	 public  static com.ulcjava.base.application.util.SystemColor getInstance(java.lang.String key)
	{
		return null;
	}


	/**
	* Returns a string representation of this <code>SystemColor</code>
	*
	* @return		a string representation of this <code>SystemColor</code>
	**/
	 public java.lang.String toString()
	{
		return null;
	}


}