package com.ulcjava.base.application.util;


	/**
	* The <code>ULCIcon</code> class is used to load icon images from a file and use
	* them in a ULC application.
<p>
</p>
Since <code>ULCIcon</code> is a subclass
	* of <code>ULCProxy</code>, <code>ULCIcon</code> behaves like all other ULC
	* widgets. This
means that instances of <code>ULCIcon</code> can only be shared
	* within one session, but not across sessions. Therefore,
<code>ULCIcon</code>
	* must not be initialized as static or static final. Use the
	* <code>setAttribute()</code> and
<code>getAttribute()</code> methods of the
	* <code>ApplicationContext</code> class
	* instead.
<p>
</p>
<b>Examples</b>
<p>
</p>
The following code shows how an
	* icon can be set up using the <code>ULCLabel</code> component.

<pre>
ULCIcon
	* icon = new ULCIcon(getClass().getResource(&quot;/icon.gif&quot;));
ULCLabel
	* iconLabel = new ULCLabel(icon);
</pre>
	*
	* @ulc.application		
	**/
 public class ULCIcon extends com.ulcjava.base.application.ULCProxy
{


	/**
	* Creates an icon from the specified URL.
	*
	* @param location 		 the URL for the image
	**/
	 public ULCIcon(java.net.URL location)
	{
		 super();
	}


	/**
	* Creates an ImageIcon from an array of bytes which were read from an image file
	* containing a supported image format, such as GIF or
JPEG.
	*
	* @param data 		 an array of pixels in an image format supported by the AWT Toolkit, such as GIF or JPEG.
	**/
	 public ULCIcon(byte[] data)
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* For backward compatibility with Anything keys used in deprecated {@link
	* com.ulcjava.base.client.UIProxy#createBasicObject(Anything)}
	*
	* @ulc.extension		
	**/
	 protected void saveState(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCIconDispatcher extends ULCProxyDispatcher
{


}
}