package com.ulcjava.base.client;


	/**
	* An list implementation to manage pending requests. Dependant on the request
	* type the list knows, if a server roundtrip should be
triggered or not. The
	* list also handles the requests which should be sent together in one server
	* roundtrip.
	*
	* @ulc.internal		
	**/
 public class PendingRequestList extends java.lang.Object
{


	/**
	* Constructs a new PendingRequestList.
	*
	**/
	 public PendingRequestList()
	{
		 super();
	}


	/**
	* Adds a request to the list. Depending on the type of the request, the list is
	* marked to invoke a server roundtrip.
	*
	* @param request 		 the request to be added to the list.
	**/
	 public void add(com.ulcjava.base.shared.internal.Request request)
	{
	}


	/**
	* Returns all requests for one server roundtrip and removes these requests from
	* the list. If the request that triggers the server
roundtrip is delivered in
	* the asynchronous event mode, requests which are added to the list after the
	* triggering request, resp.
during the server roundtrip are cached and
	* deliveredwith the next server roundtrip.
	*
	* @return		all requests for one server roundtrip
	**/
	 public com.ulcjava.base.shared.internal.Request[] getRequestsForRoundtrip()
	{
		return null;
	}


	/**
	* Returns if a server roundtrip should be invoked or not.
	*
	* @return		true if a server roundtrip should be invoked, false otherwise.
	**/
	 public boolean needToInvokeServerRoundTrip()
	{
		return false;
	}


	/**
	* Returns the size of the pending request list.
	*
	* @return		the size of the pending request list.
	**/
	 public int size()
	{
		return 0;
	}


}