package com.ulcjava.base.client;


	/**
	* This class monitors beginning and end of user interaction on the monitored
	* component. The monitored user interactions are Mouse,
MouseMotion, Focus and
	* Keyboard. In ULC, in order to optimize client-server round-trips, it is
	* important to send events from client to
the server only when the user
	* interaction ends and not for every user interaction. For example, while
	* scrolling a table with arrow key
the event should be sent to the server only
	* when the user lifts key and not all the time while key is pressed. This class
	* notifies
<code>IUserInteractionListener</code>s with
	* <code>fireUserInteractionStarted()</code> whenever a user interaction begins
	* and with
<code>fireUserInteractionEnded()</code> whenever the interaction ends.
	*
	* @ulc.extension		
	* @see		com.ulcjava.base.client.IUserInteractionListener
	**/
 public class UserInteractionMonitor extends java.lang.Object implements java.awt.event.MouseMotionListener, java.awt.event.MouseListener, java.awt.event.FocusListener, java.awt.event.KeyListener
{

	 public UserInteractionMonitor()
	{
		 super();
	}


	/**
	* Add component on which to monitor user interactions.
	*
	* @param component 		 Component to be monitored
	**/
	 public void addMonitoredComponent(java.awt.Component component)
	{
	}


	/**
	* Remove the component being monitored.
	*
	* @param component 		 Component no longer to be monitored
	**/
	 public void removeMonitoredComponent(java.awt.Component component)
	{
	}


	/**
	* Add a user interaction listener.
	*
	* @param listener 		 <code>IUserInteractionListener</code>
	**/
	 public void addUserInteractionListener(com.ulcjava.base.client.IUserInteractionListener listener)
	{
	}


	/**
	* Remove the user interaction listener.
	*
	* @param listener 		 <code>IUserInteractionListener</code>
	**/
	 public void removeUserInteractionListener(com.ulcjava.base.client.IUserInteractionListener listener)
	{
	}

	 public void mouseClicked(java.awt.event.MouseEvent event)
	{
	}

	 public void mouseEntered(java.awt.event.MouseEvent event)
	{
	}

	 public void mouseExited(java.awt.event.MouseEvent event)
	{
	}

	 public void mousePressed(java.awt.event.MouseEvent event)
	{
	}

	 public void mouseReleased(java.awt.event.MouseEvent event)
	{
	}

	 public void mouseDragged(java.awt.event.MouseEvent event)
	{
	}

	 public void mouseMoved(java.awt.event.MouseEvent event)
	{
	}

	 public void keyPressed(java.awt.event.KeyEvent event)
	{
	}

	 public void keyReleased(java.awt.event.KeyEvent event)
	{
	}

	 public void keyTyped(java.awt.event.KeyEvent event)
	{
	}

	 public void focusGained(java.awt.event.FocusEvent event)
	{
	}

	 public void focusLost(java.awt.event.FocusEvent event)
	{
	}


}