package com.ulcjava.base.server;


	/**
	* A marker interface to indicate that a class implementing this interface is
	* usedas a dispatcher inside a server-side class being or
extending {@link
	* com.ulcjava.base.application.ULCProxy}.
<p>
</p>
Dispatcher classes (and
	* objects) are needed, in order to be able to invoke private and protected
	* methods of a <code>ULCProxy</code>
object via reflection using {@link
	* com.ulcjava.base.client.UIProxy#invokeULC(String, Object[])}. To enable the
	* type of invocation an
instance of the dispatcher class is created in the
	* outerULC class and a related reflective method invocation is performed on
	* the
dispatcher instance instead of the corresponding ULC object. To ensure
	* that this works, methods inside a dispatcher class must be
<em>public</em>.
	* Since the dispatcher class is a non-static inner class it has full access to
	* the outer class.
</p>
<p>
</p>
A class implementing this interface should be
	* included as a proected inner, non-static class in a subclass of
{@link
	* com.ulcjava.base.application.ULCProxy}. The dispatcher class should inherit
	* from the dispatch class of the super class of the
outer ULC class and should
	* have a public no-argument constructor. In essence this means that the
	* inheritance path of dispatche classes
mimics the inheritance path of the
	* outerULC classes.
</p>
<p>
</p>
To keep things simple, ULC sticks to the
	* following naming convention for dispatcher classes: If the outer ULC class is
	* called
<code>ULC&lt;Xyz&gt;</code> then the inner dispatcher class should
	* holdthe name <code>ULC&lt;Xyz&gt;Dispatcher</code>
</p>
<p>
</p>
The outer
	* ULCclass must be able to acquire an instance of its own dispatcher class, and
	* not for example an instance of the super class's
dispatcher class. A correct
	* dispatcher instance is acquired via the method
{@link
	* com.ulcjava.base.application.ULCProxy#createDispatcher()}, which must be
	* overriden appropriately in subclasses of
{@link
	* com.ulcjava.base.application.ULCProxy}.
<p>
</p>
As an example, consider the
	* following correct inheritance situation for two subclasses of {@link
	* com.ulcjava.base.application.ULCProxy}.

<pre>
public class ULCProxy ...
	* {
...protected IDispatcher createDispatcher() {
return new
	* ULCProxyDispatcher();
}
protected class ULCProxyDispatcher implements
	* IDispatcher {
...
}
}
public class ULCMySubclass1 extends ULCProxy
	* {
...
protected IDispatcher createDispatcher() {
return new
	* ULCMySubclass1Dispatcher();
}
protected class ULCMySubclass1Dispatcher
	* extendsULCProxyDispatcher {
...
}
}
public class ULCMySubclass2 extends
	* ULCMySubclass1 {
...
protected IDispatcher createDispatcher() {
return new
	* ULCMySubclass2Dispatcher();
}
protected class ULCMySubclass2Dispatcher
	* extendsULCMySubclass1Dispatcher {
...
}
}
</pre>

<p>
</p>
For simplicity and
	* convenience, it is recommended to define dispatcher methods according to the
	* following pattern:

<pre>
public class ULCMySubclass1 extends ULCProxy
	* {
...
// Your private or protected method with custom arguments
private void
	* myLocalPrivateMethod(String arg1, int arg2) {
...
}
protected class
	* ULCMySubclass1Dispatcher extends ULCProxyDispatcher {
// The dispatcher
	* methodthat allows to invoke the protected or
// private method of the outer
	* ULC class. It must be public and
// should be final. It shouls imply delegate
	* to a method with the
// same name on the outer class.
public final void
	* myLocalPrivateMethod(String arg1, int arg2)
	* {
ULCMySubclass1.this.myLocalPrivateMethod(arg1, arg2);
}
}
}
</pre>

Given
	* the above implementation of <code>ULCMySubclass1</code>, one may invoke the
	* private method
<code>ULCMySubclass1.myLocalPrivateMethod()</code> on the
	* client-side <code>UIProxy</code> instance associated with a
	* server-side
instance of <code>ULCMySubclass1</code>. This can be done via
	* {@link com.ulcjava.base.client.UIProxy#invokeULC(String, Object[])}.
E.g., a
	* related invocation on the client side may look as
	* follows:

<pre>
invokeULC(&quot;myLocalPrivateMethod&quot;, new Object[]{
	* &quot;myArgument1&quot;, new Integer(4711) }
</pre>
	*
	* @ulc.extension		
	**/
 public interface IDispatcher extends java.io.Serializable
{


}