package com.ulcjava.base.server;


	/**
	* A model adapter provider manages model adapters for models. A custom model
	* adapter factory can be registered using the
<modelAdapterProviderClassName>
	* element in the application's ULCApplicationConfiguration.xml file. Classes
	* implementing this interface
should have a public no-argument constructor,
	* since ULC creates instances of them via reflection. By default
	* the
<code>DefaultModelAdapterFactory</code> is used as model adapter provider.
	*
	* @ulc.extension		
	* @see		IContainerServices#MODEL_ADAPTER_PROVIDER_KEY
	* @see		DefaultModelAdapterProvider
	**/
 public interface IModelAdapterProvider extends java.io.Serializable
{


	/**
	* Registers a model adapter for the given model type and model. The model
	* adapterhas to be registered before the first use of the
model, e.g. before
	* setting the model to the corresponding component.
	*
	* @param modelType 		 the type of the model for which a adapter has to be registered
	* @param model 		 the model for which the adapter has to be registered
	* @param adapter 		 the adapter which has to be registered
	**/
	 public void registerModelAdapter(java.lang.Class modelType, java.lang.Object model, java.lang.Object adapter);

	/**
	* Returns the model adapter for the given model type and model.
	*
	* @param modelType 		 type of the model
	* @param model 		 model object
	* @return		the model adapter for the given model type and model
	**/
	 public java.lang.Object getModelAdapter(java.lang.Class modelType, java.lang.Object model);

}