package com.ulcjava.base.server;


	/**
	* A log config provider, which provides a logging configuration on the basis of
	* an attribute value obtained via the container service of
the current ULC
	* session. The container service is obtained via {@link
	* ULCSession#getContainerServices()}. The key for the attribute is
{@link
	* IContainerServices#LOG_CONFIG_KEY} and it is accessed via {@link
	* IContainerServices#getAttribute(String)}.
<p>
</p>
If the logging
	* configuration cannot be accessed in the above described way, then a default
	* logging configuration is provided via
{@link
	* PropertiesLogConfigProvider#getLogConfig()}.
<p>
</p>
This implementation of
	* alog config provider is used by the servlet container adapter and the EJB
	* container adapter of ULC. It is able to
associate ULCSessions from different
	* servlets or EJBs with different log configurations.
	*
	* @see		IContainerServices#getAttribute(String)
	* @see		ISimpleLogConfigProvider
	* @see		SimpleLogConfig
	* @ulc.extension		
	**/
 public class SessionLogConfigProvider extends com.ulcjava.base.shared.logging.PropertiesLogConfigProvider
{


	/**
	* Initialize the log manager such that is it used an instance of {@link
	* SessionLogConfigProvider} in order to get a corresponding
{@link
	* SimpleLogConfig} instance. If the application configuration defines a value
	* for the server log level, the log level of the log
manager is set to it.
	*
	* @see		SimpleLogConfig
	* @ulc.internal		
	**/
	 public  static void initializeLogManager()
	{
	}

	 protected com.ulcjava.base.shared.logging.SimpleLogConfig createLogConfig()
	{
		return null;
	}

	 public com.ulcjava.base.shared.logging.SimpleLogConfig getLogConfig()
	{
		return null;
	}


}