package com.ulcjava.base.shared;


	/**
	* A coder registry manages coders for classes whose instances should be
	* marshalled using the ULC stream mechanism. To work with a given set
of
	* classeswhose objects might be marshalled, ULC needs a ready-made coder
	* registry with coders for these classes. This interface is the
super type for
	* provider classes who return such a ready-made registry.
<p>
</p>
Classes
	* implementing this interface should have a public no-argument constructor,
	* since ULC creates instances of them via reflection.
	*
	* @ulc.extension		
	* @see		CoderRegistry
	**/
 public interface ICoderRegistryProvider
{


	/**
	* Gets a coder registry to be used for client server communication in ULC using
	* the ULC stream mechanism. It is expected that all
coders required to marshall
	* objects during communication are already registered at the returned coder
	* registry.
	*
	* @return		the ready-made coder registry
	**/
	com.ulcjava.base.shared.CoderRegistry getCoderRegistry();

}