package com.ulcjava.base.shared;


	/**
	* Defines constants used for the ULC event handling.
	*
	* @ulc.application		
	* @deprecated		Use {@link UlcEventConstants} and {@link UlcEventCategories} instead.
	**/
 public interface IUlcEventConstants
{

	/**
	* The mode for synchronous event delivery.
	*
	* @see		com.ulcjava.base.application.ClientContext#setEventDeliveryMode
	* @see		com.ulcjava.base.application.ClientContext#getEventDeliveryMode
	* @see		com.ulcjava.base.application.ClientContext#setModelUpdateMode
	* @see		com.ulcjava.base.application.ClientContext#getModelUpdateMode
	**/
	 public  final  static int SYNCHRONOUS_MODE = 0;

	/**
	* The mode for asynchronous event delivery.
	*
	* @see		com.ulcjava.base.application.ClientContext#setEventDeliveryMode
	* @see		com.ulcjava.base.application.ClientContext#getEventDeliveryMode
	* @see		com.ulcjava.base.application.ClientContext#setModelUpdateMode
	* @see		com.ulcjava.base.application.ClientContext#getModelUpdateMode
	**/
	 public  final  static int ASYNCHRONOUS_MODE = 0;

	/**
	* The mode for deferred event delivery.
	*
	* @see		com.ulcjava.base.application.ClientContext#setEventDeliveryMode
	* @see		com.ulcjava.base.application.ClientContext#getEventDeliveryMode
	* @see		com.ulcjava.base.application.ClientContext#setModelUpdateMode
	* @see		com.ulcjava.base.application.ClientContext#getModelUpdateMode
	**/
	 public  final  static int DEFERRED_MODE = 0;

	/**
	* The model update event category. For internal use only.
	*
	**/
	 public  final  static int MODEL_UPDATE = 0;

	/**
	* The event category of the action event.
	*
	**/
	 public  final  static int ACTION_EVENT = 0;

	/**
	* The id for the action performed method of the action event.
	*
	**/
	 public  final  static int ACTION_PERFORMED = 0;

	/**
	* The event category of the selection changed event.
	*
	**/
	 public  final  static int SELECTION_CHANGED_EVENT = 0;

	/**
	* The id for the selection changed method of the selection changed event.
	*
	**/
	 public  final  static int SELECTION_CHANGED = 0;

	/**
	* The event category of the focus event.
	*
	**/
	 public  final  static int FOCUS_EVENT = 0;

	/**
	* The id for the focus gained method of the focus event.
	*
	**/
	 public  final  static int FOCUS_GAINED = 0;

	/**
	* The id for the focus lost method of the focus event.
	*
	**/
	 public  final  static int FOCUS_LOST = 0;

	/**
	* The event category of the value changed event.
	*
	**/
	 public  final  static int VALUE_CHANGED_EVENT = 0;

	/**
	* The id for the value changed method of the value changed event.
	*
	**/
	 public  final  static int VALUE_CHANGED = 0;

	/**
	* The event category of the tree expansion event.
	*
	**/
	 public  final  static int TREE_EXPANSION_EVENT = 0;

	/**
	* The id for the tree collapsed method of the tree expansion event.
	*
	**/
	 public  final  static int TREE_COLLAPSED = 0;

	/**
	* The id for the tree expanded method of the tree expansion event.
	*
	**/
	 public  final  static int TREE_EXPANDED = 0;

	/**
	* The event category of the window event.
	*
	**/
	 public  final  static int WINDOW_EVENT = 0;

	/**
	* The id for the window closing method of the window event.
	*
	**/
	 public  final  static int WINDOW_CLOSING = 0;

	/**
	* The event category of the internal frame event.
	*
	**/
	 public  final  static int INTERNAL_FRAME_EVENT = 0;

	/**
	* The id for the internal frame closing method of the internal frame event.
	*
	**/
	 public  final  static int INTERNAL_FRAME_CLOSING = 0;

	/**
	* The event category of the hyperlink event.
	*
	**/
	 public  final  static int HYPERLINK_EVENT = 0;

	/**
	* The id for the link activated method of the hyperlink event.
	*
	**/
	 public  final  static int LINK_ACTIVATED = 0;

	/**
	* The id for the link error method of the hyperlink event.
	*
	**/
	 public  final  static int LINK_ERROR = 0;

	/**
	* The event category of the key event.
	*
	**/
	 public  final  static int KEY_EVENT = 0;

	/**
	* The id for the key typed method of the key event.
	*
	**/
	 public  final  static int KEY_TYPED = 0;

	/**
	* The event category of the tree selection event.
	*
	**/
	 public  final  static int TREE_SELECTION_EVENT = 0;

	/**
	* The id for the tree selection method of the tree selection event.
	*
	**/
	 public  final  static int TREE_SELECTION = 0;

	/**
	* The event category of the list selection event.
	*
	**/
	 public  final  static int LIST_SELECTION_EVENT = 0;

	/**
	* The id for the list selection method of the list selection event.
	*
	**/
	 public  final  static int LIST_SELECTION = 0;

	/**
	* The event category of the round trip event.
	*
	**/
	 public  final  static int ROUND_TRIP_EVENT = 0;

	/**
	* The id for the round trip did start method of the round trip event.
	*
	**/
	 public  final  static int ROUND_TRIP_DID_START = 0;

	/**
	* The id for the round trip will end method of the round trip event.
	*
	**/
	 public  final  static int ROUND_TRIP_WILL_END = 0;

	/**
	* The event category of the adjustment event.
	*
	**/
	 public  final  static int ADJUSTMENT_EVENT = 0;

	/**
	* The id for the adjustment value changed method of the adjustment event.
	*
	**/
	 public  final  static int ADJUSTMENT_VALUE_CHANGED = 0;

	/**
	* The event category of the (synthetic) keyboard action event.
	*
	**/
	 public  final  static int KEYBOARD_ACTION_EVENT = 0;

	/**
	* The id for the keyboard action method of the keyboard action event.
	*
	**/
	 public  final  static int KEYBOARD_ACTION = 0;


}