package com.ulcjava.base.shared.internal;


	/**
	* Encodes and decodes to and from Base64 notation.
<p>
</p>
<p>
</p>
Change
	* Log:
</p>
<ul>
<li>v2.1 - Cleaned up javadoc comments and unused variables
	* andmethods. Added some convenience methods for reading and writing to
	* and
fromfiles.</li>
<li>v2.0.2 - Now specifies UTF-8 encoding in places where
	* the code fails on systems with other encodings (like EBCDIC).</li>
<li>v2.0.1
	* - Fixed an error when decoding a single byte, that is, when the encoded data
	* was a single byte.</li>
<li>v2.0 - I got rid of methods that used booleans to
	* set options. Now everything is more consolidated and cleaner. The code now
	* detects
when data that's being decoded is gzip-compressed and will decompress
	* it automatically. Generally things are cleaner. You'll probably
have to
	* changesome method calls that you were making to support the new options
	* format(<tt>int</tt>s that you "OR" together).</li>
<li>v1.5.1 - Fixed bug
	* whendecompressing and decoding to a byte[] using <tt>decode( String s,
	* booleangzipCompressed )</tt>. Added
the ability to "suspend" encoding in the
	* Output Stream so you can turn on and off the encoding if you need to embed
	* base64 data in an
otherwise "normal" stream (like an XML file).</li>
<li>v1.5
	* - Output stream pases on flush() command but doesn't do anything itself. This
	* helps when using GZIP streams. Added the ability
to GZip-compress objects
	* before encoding them.</li>
<li>v1.4 - Added helper methods to read/write
	* files.</li>
<li>v1.3.6 - Fixed OutputStream.flush() so that 'position' is
	* reset.</li>
<li>v1.3.5 - Added flag to turn on and off line breaks. Fixed bug
	* in input stream where last buffer being read, if not completely full,
was not
	* returned.</li>
<li>v1.3.4 - Fixed when "improperly padded stream" error was
	* thrown at the wrong time.</li>
<li>v1.3.3 - Fixed I/O streams which were
	* totally messed up.</li>
</ul>
<p>
</p>
<p>
</p>
I am placing this code in the
	* Public Domain. Do with it as you will. This software comes with no guarantees
	* or warranties but with plenty
of well-wishing instead! Please visit <a
	* href="http://iharder.net/base64">http://iharder.net/base64</a> periodically
	* tocheck for
updates or to contribute improvements.
</p>
	*
	* @author		Robert Harder
	* @author		rob@iharder.net
	* @version		2.1
	* @ulc.internal		
	**/
 public class Base64 extends java.lang.Object
{

	/**
	* No options specified. Value is zero.
	*
	**/
	 public  final  static int NO_OPTIONS = 0;

	/**
	* Specify encoding.
	*
	**/
	 public  final  static int ENCODE = 0;

	/**
	* Specify decoding.
	*
	**/
	 public  final  static int DECODE = 0;

	/**
	* Specify that data should be gzip-compressed.
	*
	**/
	 public  final  static int GZIP = 0;

	/**
	* Don't break lines when encoding (violates strict Base64 specification)
	*
	**/
	 public  final  static int DONT_BREAK_LINES = 0;


	/**
	* Defeats instantiation.
	*
	**/
	 private Base64()
	{
		 super();
	}


	/**
	* Serializes an object and returns the Base64-encoded version of that serialized
	* object. If the object cannot be serialized or there is
another error, the
	* method will return <tt>null</tt>. The object is not GZip-compressed before
	* being encoded.
	*
	* @param serializableObject 		 The object to encode
	* @return		The Base64-encoded object
	* @since		1.4
	**/
	 public  static java.lang.String encodeObject(java.io.Serializable serializableObject)
	{
		return null;
	}


	/**
	* Serializes an object and returns the Base64-encoded version of that serialized
	* object. If the object cannot be serialized or there is
another error, the
	* method will return <tt>null</tt>.
<p>
</p>
Valid options:

<pre>
GZIP:
	* gzip-compresses object before encoding it.
DONT_BREAK_LINES: don't break
	* linesat 76 characters
&lt;i&gt;Note: Technically, this makes your encoding
	* non-compliant.&lt;/i&gt;
</pre>

<p>
</p>
Example: <code>encodeObject( myObj,
	* Base64.GZIP )</code> or
<p>
</p>
Example: <code>encodeObject( myObj,
	* Base64.GZIP | Base64.DONT_BREAK_LINES )</code>
	*
	* @param serializableObject 		 The object to encode
	* @param options 		 Specified options
	* @return		The Base64-encoded object
	* @see		Base64#GZIP
	* @see		Base64#DONT_BREAK_LINES
	* @since		2.0
	**/
	 public  static java.lang.String encodeObject(java.io.Serializable serializableObject, int options)
	{
		return null;
	}


	/**
	* Encodes a byte array into Base64 notation. Does not GZip-compress data.
	*
	* @param source 		 The data to convert
	* @since		1.4
	**/
	 public  static java.lang.String encodeBytes(byte[] source)
	{
		return null;
	}


	/**
	* Encodes a byte array into Base64 notation.
<p>
</p>
Valid
	* options:

<pre>
GZIP:gzip-compresses object before encoding
	* it.
DONT_BREAK_LINES: don't break lines at 76 characters
&lt;i&gt;Note:
	* Technically, this makes your encoding
	* non-compliant.&lt;/i&gt;
</pre>

<p>
</p>
Example: <code>encodeBytes( myData,
	* Base64.GZIP )</code> or
<p>
</p>
Example: <code>encodeBytes( myData,
	* Base64.GZIP | Base64.DONT_BREAK_LINES )</code>
	*
	* @param source 		 The data to convert
	* @param options 		 Specified options
	* @see		Base64#GZIP
	* @see		Base64#DONT_BREAK_LINES
	* @since		2.0
	**/
	 public  static java.lang.String encodeBytes(byte[] source, int options)
	{
		return null;
	}


	/**
	* Encodes a byte array into Base64 notation. Does not GZip-compress data.
	*
	* @param source 		 The data to convert
	* @param off 		 Offset in array where conversion should begin
	* @param len 		 Length of data to convert
	* @since		1.4
	**/
	 public  static java.lang.String encodeBytes(byte[] source, int off, int len)
	{
		return null;
	}


	/**
	* Encodes a byte array into Base64 notation.
<p>
</p>
Valid
	* options:

<pre>
GZIP:gzip-compresses object before encoding
	* it.
DONT_BREAK_LINES: don't break lines at 76 characters
&lt;i&gt;Note:
	* Technically, this makes your encoding
	* non-compliant.&lt;/i&gt;
</pre>

<p>
</p>
Example: <code>encodeBytes( myData,
	* Base64.GZIP )</code> or
<p>
</p>
Example: <code>encodeBytes( myData,
	* Base64.GZIP | Base64.DONT_BREAK_LINES )</code>
	*
	* @param source 		 The data to convert
	* @param off 		 Offset in array where conversion should begin
	* @param len 		 Length of data to convert
	* @param options 		 Specified options
	* @see		Base64#GZIP
	* @see		Base64#DONT_BREAK_LINES
	* @since		2.0
	**/
	 public  static java.lang.String encodeBytes(byte[] source, int off, int len, int options)
	{
		return null;
	}


	/**
	* Very low-level access to decoding ASCII characters in the form of a byte
	* array.Does not support automatically gunzipping or any
other "fancy" features.
	*
	* @param source 		 The Base64 encoded data
	* @param off 		 The offset of where to begin decoding
	* @param len 		 The length of characters to decode
	* @return		decoded data
	* @since		1.3
	**/
	 public  static byte[] decode(byte[] source, int off, int len)
	{
		return null;
	}


	/**
	* Decodes data from Base64 notation, automatically detecting gzip-compressed
	* dataand decompressing it.
	*
	* @param s 		 the string to decode
	* @return		the decoded data
	* @since		1.4
	**/
	 public  static byte[] decode(java.lang.String s)
	{
		return null;
	}


	/**
	* Attempts to decode Base64 data and deserialize a Java Object within. Returns
	* <tt>null</tt> if there was an error.
	*
	* @param encodedObject 		 The Base64 data to decode
	* @return		The decoded and deserialized object
	* @since		1.5
	**/
	 public  static java.lang.Object decodeToObject(java.lang.String encodedObject)
	{
		return null;
	}


	/**
	* Convenience method for encoding data to a file.
	*
	* @param dataToEncode 		 byte array of data to encode in base64 form
	* @param filename 		 Filename for saving encoded data
	* @return		<tt>true</tt> if successful, <tt>false</tt> otherwise
	* @since		2.1
	**/
	 public  static boolean encodeToFile(byte[] dataToEncode, java.lang.String filename)
	{
		return false;
	}


	/**
	* Convenience method for decoding data to a file.
	*
	* @param dataToDecode 		 Base64-encoded data as a string
	* @param filename 		 Filename for saving decoded data
	* @return		<tt>true</tt> if successful, <tt>false</tt> otherwise
	* @since		2.1
	**/
	 public  static boolean decodeToFile(java.lang.String dataToDecode, java.lang.String filename)
	{
		return false;
	}


	/**
	* Convenience method for reading a base64-encoded file and decoding it.
	*
	* @param filename 		 Filename for reading encoded data
	* @return		decoded byte array or null if unsuccessful
	* @since		2.1
	**/
	 public  static byte[] decodeFromFile(java.lang.String filename)
	{
		return null;
	}


	/**
	* Convenience method for reading a binary file and base64-encoding it.
	*
	* @param filename 		 Filename for reading binary data
	* @return		base64-encoded string or null if unsuccessful
	* @since		2.1
	**/
	 public  static java.lang.String encodeFromFile(java.lang.String filename)
	{
		return null;
	}


	/**
	* A {@link Base64.InputStream} will read data from another
	* <tt>java.io.InputStream</tt>, given in the constructor, and
	* encode/decode
to/from Base64 notation on the fly.
	*
	* @see		Base64
	* @since		1.3
	**/
 public  static class InputStream extends java.io.FilterInputStream
{


	/**
	* Constructs a {@link Base64.InputStream} in DECODE mode.
	*
	* @param in 		 the <tt>java.io.InputStream</tt> from which to read data.
	* @since		1.3
	**/
	 public InputStream(java.io.InputStream in)
	{
		 super();
	}


	/**
	* Constructs a {@link Base64.InputStream} in either ENCODE or DECODE
	* mode.
<p>
</p>
Valid options:

<pre>
ENCODE or DECODE: Encode or Decode as
	* data is read.
DONT_BREAK_LINES: don't break lines at 76 characters
(only
	* meaningful when encoding)
&lt;i&gt;Note: Technically, this makes your
	* encodingnon-compliant.&lt;/i&gt;
</pre>

<p>
</p>
Example: <code>new
	* Base64.InputStream( in, Base64.DECODE )</code>
	*
	* @param in 		 the <tt>java.io.InputStream</tt> from which to read data.
	* @param options 		 Specified options
	* @see		Base64#ENCODE
	* @see		Base64#DECODE
	* @see		Base64#DONT_BREAK_LINES
	* @since		2.0
	**/
	 public InputStream(java.io.InputStream in, int options)
	{
		 super();
	}


	/**
	* Reads enough of the input stream to convert to/from Base64 and returns the
	* nextbyte.
	*
	* @return		next byte
	* @since		1.3
	**/
	 public int read()throws java.io.IOException
	{
		return 0;
	}


	/**
	* Calls {@link #read()} repeatedly until the end of stream is reached or
	* <var>len</var> bytes are read. Returns number of bytes
read into array or -1
	* if end of stream is encountered.
	*
	* @param dest 		 array to hold values
	* @param off 		 offset for array
	* @param len 		 max number of bytes to read into array
	* @return		bytes read into array or -1 if end of stream is encountered.
	* @since		1.3
	**/
	 public int read(byte[] dest, int off, int len)throws java.io.IOException
	{
		return 0;
	}


}
	/**
	* A {@link Base64.OutputStream} will write data to another
	* <tt>java.io.OutputStream</tt>, given in the constructor, and
encode/decode
	* to/from Base64 notation on the fly.
	*
	* @see		Base64
	* @since		1.3
	**/
 public  static class OutputStream extends java.io.FilterOutputStream
{


	/**
	* Constructs a {@link Base64.OutputStream} in ENCODE mode.
	*
	* @param out 		 the <tt>java.io.OutputStream</tt> to which data will be written.
	* @since		1.3
	**/
	 public OutputStream(java.io.OutputStream out)
	{
		 super((java.io.OutputStream)null);
	}


	/**
	* Constructs a {@link Base64.OutputStream} in either ENCODE or DECODE
	* mode.
<p>
</p>
Valid options:

<pre>
ENCODE or DECODE: Encode or Decode as
	* data is read.
DONT_BREAK_LINES: don't break lines at 76 characters
(only
	* meaningful when encoding)
&lt;i&gt;Note: Technically, this makes your
	* encodingnon-compliant.&lt;/i&gt;
</pre>

<p>
</p>
Example: <code>new
	* Base64.OutputStream( out, Base64.ENCODE )</code>
	*
	* @param out 		 the <tt>java.io.OutputStream</tt> to which data will be written.
	* @param options 		 Specified options.
	* @see		Base64#ENCODE
	* @see		Base64#DECODE
	* @see		Base64#DONT_BREAK_LINES
	* @since		1.3
	**/
	 public OutputStream(java.io.OutputStream out, int options)
	{
		 super((java.io.OutputStream)null);
	}


	/**
	* Writes the byte to the output stream after converting to/from Base64 notation.
	* When encoding, bytes are buffered three at a time
before the output stream
	* actually gets a write() call. When decoding, bytes are buffered four at a time.
	*
	* @param theByte 		 the byte to write
	* @since		1.3
	**/
	 public void write(int theByte)throws java.io.IOException
	{
	}


	/**
	* Calls {@link #write(int)} repeatedly until <var>len</var> bytes are written.
	*
	* @param theBytes 		 array from which to read bytes
	* @param off 		 offset for array
	* @param len 		 max number of bytes to read into array
	* @since		1.3
	**/
	 public void write(byte[] theBytes, int off, int len)throws java.io.IOException
	{
	}


	/**
	* Method added by PHIL. [Thanks, PHIL. -Rob] This pads the buffer without
	* closingthe stream.
	*
	**/
	 public void flushBase64()throws java.io.IOException
	{
	}


	/**
	* Flushes and closes (I think, in the superclass) the stream.
	*
	* @since		1.3
	**/
	 public void close()throws java.io.IOException
	{
	}


	/**
	* Suspends encoding of the stream. May be helpful if you need to embed a piece
	* ofbase640-encoded data in a stream.
	*
	* @since		1.5.1
	**/
	 public void suspendEncoding()throws java.io.IOException
	{
	}


	/**
	* Resumes encoding of the stream. May be helpful if you need to embed a piece of
	* base640-encoded data in a stream.
	*
	* @since		1.5.1
	**/
	 public void resumeEncoding()
	{
	}


}
}