package com.ulcjava.base.shared.logging;


	/**
	* A log configuration for the {@link SimpleLogManager} class. The log
	* configuration is used to determine how the log manager logs messages.
In
	* particular it determines the message format and the log level for logged
	* messages as well as the stream to which the log manager
writes. The log
	* manager class {@link LogManager} is a singleton and the standard instance
	* typebound to the singleton is
{@link SimpleLogManager}. The simple log
	* managersingleton can be provided with different log configurations via the
	* interface
{@link ISimpleLogConfigProvider}. Whenever a log message is
	* supposedto written out, the simple log manager executes
{@link
	* ISimpleLogConfigProvider#getLogConfig()} in order to determine the log
	* configuration, which it uses to actually log the message.
An application
	* developer can customize the strategy on how the simple log manager acquires a
	* log configuration. This done by setting a
corresponding provider via {@link
	* SimpleLogManager#setLogConfigProvider(ISimpleLogConfigProvider)}.
<p>
</p>
I.e.
	* for ULC, this matters if several server-side ULC session run in the same JVM
	* but require different log configurations. The default
implementation of
	* {@linkISimpleLogConfigProvider} is {@link DefaultSimpleLogConfigProvider}
	* which is the default log config provider of
the simple log manager singleton.
	*
	* @see		SimpleLogManager
	* @see		DefaultSimpleLogConfigProvider
	* @see		ISimpleLogConfigProvider
	* @ulc.extension		
	**/
 public class SimpleLogConfig extends java.lang.Object implements java.io.Serializable
{
	 public  final  static java.io.PrintStream DEFAULT_LOG_STREAM = null;
	 public  final  static java.lang.String DEFAULT_MESSAGE_FORMAT_STRING = null;
	 public  final  static com.ulcjava.base.shared.logging.Level DEFAULT_LOG_LEVEL = null;


	/**
	* Constructs a log configuration with default values for the log stream, the
	* message format and the log level. The default log stream
is {@link
	* System#err}(the value of {@link #DEFAULT_LOG_STREAM}), the default log level
	* is {@link Level#WARNING} (the value of
{@link #DEFAULT_LOG_LEVEL}) and the
	* default message format string is
<code>{0}\t{1, date, dd.MM.yyyy
	* HH:mm:ss.SSS}\t{2}\t{3}\t{4}\t{5}\t{6}\t{7}\t{8}"</code> (the value of
{@link
	* #DEFAULT_MESSAGE_FORMAT}).
	*
	**/
	 public SimpleLogConfig()
	{
		 super();
	}

	 public com.ulcjava.base.shared.logging.Level getLevel()
	{
		return null;
	}

	 public void setLevel(com.ulcjava.base.shared.logging.Level level)
	{
	}

	 public java.io.PrintStream getLogStream()
	{
		return null;
	}

	 public void setLogStream(java.io.PrintStream logStream)
	{
	}

	 public java.text.MessageFormat getMessageFormat()
	{
		return null;
	}

	 public void setMessageFormat(java.text.MessageFormat messageFormat)
	{
	}


}