/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.easydeployment.server;

import com.ulcjava.base.server.ApplicationConfiguration;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Dispatches to the resource that launches application in the applet or jnlp client environment depending on the defaultClientEnvironment
 * tag in the ULCApplicationConfigurtaion.xml.
 */
public class IndexServlet extends HttpServlet {
    
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ApplicationConfiguration config = ApplicationConfiguration.getInstance();
        
        if (config == null || config.getDefaultClientEnvironment().equals(ApplicationConfiguration.APPLET)) {
            response.sendRedirect(getInitParameter("applet-redirect"));
        } else {
            response.sendRedirect(getInitParameter("jnlp-redirect"));
            
        }
    }
    

}