/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */
package com.ulcjava.easydeployment.server;

import com.ulcjava.base.shared.internal.ClassUtilities;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet that provides access to resources bundled within the application, as for example images. A proper mime-type must be configured in
 * the web.xml for the resource that the download is allowed.
 */
public class ResourceDownloader extends javax.servlet.http.HttpServlet implements javax.servlet.Servlet {
    private static final int BUFFER_SIZE = 4096;
    
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        
        String resourcePath = request.getServletPath() + request.getPathInfo();
        String mimeType = getServletContext().getMimeType(resourcePath);
        if (mimeType == null) {
            try {
                response.sendError(HttpServletResponse.SC_FORBIDDEN,
                        "Only file that have a mime-type mapping can be accessed, No mime type defined for " + resourcePath);
            } catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        response.setContentType(mimeType);
        

        InputStream file = ClassUtilities.getDefaultClassLoader().getResourceAsStream(resourcePath);
        
        if (file != null) {
            byte[] buffer = new byte[BUFFER_SIZE];
            try {
                for (int len = file.read(buffer); len >= 0; len = file.read(buffer)) {
                    response.getOutputStream().write(buffer, 0, len);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                response.sendError(HttpServletResponse.SC_NOT_FOUND);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        
    }
}