/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.applet.application; import com.ulcjava.base.shared.internal.VersionInfo;

import com.ulcjava.base.application.ULCRootPane;
import com.ulcjava.base.application.util.Dimension;
import com.ulcjava.base.server.IDispatcher;
import com.ulcjava.environment.applet.server.ULCAppletFrame;

/**
 * <code>ULCAppletPane</code> is a top-level container that uses an applet's content pane as display area. This component can only be used
 * once per application and only if the application's client is deployed as applet.
 * <p>
 * </p>
 * From the developer's point of view, this component behaves similarly to a "normal" window, except that it does not generate any window
 * events. Note that the <code>ULCAppletPane</code> has to be used whenever the ULC application client runs as an applet embedded in a web
 * page. (Also see the chapter on deployment as Applet in the ULC Deployment Guide.)
 * <p>
 * </p>
 * <b>Features</b>
 * <ul>
 * <li><code>ULCAppletPane</code> can be used only in applications designed to run within applet client container
 * <li>It allows the developer to access the in-page applet frame.
 * <li>There is only one instance per session, accessed via a static call to the <code>ULCAppletPane</code> class.
 * </ul>
 * <p>
 * </p>
 * <b>Examples</b>
 * <p>
 * </p>
 * Since there can be only one such frame per applet, a static method has to be used to access this component:
 * 
 * <pre>
 * ULCAppletPane appletPane = ULCAppletPane.getInstance();
 * appletPane.add(new ULCLabel(&quot;Hi!&quot;));
 * </pre>
 * 
 * @ulc.application
 */
public class ULCAppletPane extends ULCRootPane { static {VersionInfo.addVersionInfo(ULCAppletPane.class, "build.3670");}
    private static final String APPLET_PANE_KEY = "applet-pane";
    
    protected String getPropertyPrefix() {
        return "Panel";
    }
    
    protected String typeString() {
        return "com.ulcjava.environment.applet.client.UIAppletPane";
    }
    
    private ULCAppletPane() {
        ULCAppletFrame appletFrame = new ULCAppletFrame();
        appletFrame.setContentPane(this);
        markUncollectable();
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @param preferredSize the preferred size Dimension
     * @throws UnsupportedOperationException
     */
    public void setPreferredSize(Dimension preferredSize) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setPreferredSize() is not supported for applets");
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @param minimumSize the minimum size Dimension
     * @throws UnsupportedOperationException
     */
    public void setMinimumSize(Dimension minimumSize) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setMinimumSize() is not supported for applets");
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @throws UnsupportedOperationException
     */
    public void setMaximumSize(Dimension maximumSize) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setMaximumSize() is not supported for applets");
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @throws UnsupportedOperationException
     */
    public float getAlignmentX() {
        throw new UnsupportedOperationException("getAlignmentX() is not supported for applets");
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @throws UnsupportedOperationException
     */
    public void setAlignmentX(float alignmentX) {
        throw new UnsupportedOperationException("setAlignmentX() is not supported for applets");
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @throws UnsupportedOperationException
     */
    public float getAlignmentY() {
        throw new UnsupportedOperationException("getAlignmentY() is not supported for applets");
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @throws UnsupportedOperationException
     */
    public void setAlignmentY(float alignmentY) {
        throw new UnsupportedOperationException("setAlignmentY() is not supported for applets");
    }
    
    /**
     * This operation is not supported for applets.
     * 
     * @throws UnsupportedOperationException
     */
    public void revalidate() {
        throw new UnsupportedOperationException("revalidate() is not supported for applets");
    }
    
    protected void uploadStateUI() {
        super.uploadStateUI();
        
        // Register UIAppletFrame in client registry. See UBA-1113.
        invokeUI("registerParent", new Object[] {getParent()});
    }
    
    /**
     * Returns the applet pane singleton that represents the applet area (in the browser window).
     * 
     * @return the applet pane singleton that represents the applet area
     */
    public static ULCAppletPane getInstance() {
        ULCAppletPane appletPane = (ULCAppletPane)getSession().getAttribute(APPLET_PANE_KEY);
        if (appletPane == null) {
            appletPane = new ULCAppletPane();
            getSession().setAttribute(APPLET_PANE_KEY, appletPane);
        }
        return appletPane;
    }

    /**
     * @ulc.extension
     */
    protected IDispatcher createDispatcher() {
        return new ULCAppletPaneDispatcher();
    }
    
    /**
     * @ulc.extension
     */
    protected class ULCAppletPaneDispatcher extends ULCRootPaneDispatcher {
    }
}
