/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.applet.client;

import com.ulcjava.base.client.IBrowserService;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.Logger;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * @ulc.extension
 */
public class AppletBrowserService implements IBrowserService {
    private static final Logger LOG = Logger.getLogger("com.ulcjava.environment.applet.client");
    
    public void showDocument(String urlString) {
        try {
            LOG.log(Level.FINEST, "Executing AppletContext.showDocument(new URL(\"" + urlString + "\"))");
            AbstractAppletLauncher.getApplet().getAppletContext().showDocument(new URL(urlString));
        } catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Invalid url " + urlString + "(" + e + ")");
        }
    }
    
    public void showDocument(String urlString, String target) {
        try {
            LOG.log(Level.FINEST, "Executing AppletContext.showDocument(new URL(\"" + urlString + "\", \"" + target + "\"))");
            AbstractAppletLauncher.getApplet().getAppletContext().showDocument(new URL(urlString), target);
        } catch (MalformedURLException e) {
            LOG.log(Level.WARNING, "Invalid url " + urlString + "(" + e + ")");
        }
    }
}
