package com.ulcjava.testframework;


	/**
	* Base class for test cases in test environments that are running the client and
	* the server side integrated in the same VM.
	*
	**/
 public  abstract class AbstractIntegratedTestCase extends com.ulcjava.testframework.AbstractTestCase
{


	/**
	* Creates a test case with no name and a default max fail count.
	*
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractIntegratedTestCase()
	{
		 super();
	}


	/**
	* Creates a test case with no name and the specified max fail count.
	*
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractIntegratedTestCase(int maxFailCount)
	{
		 super();
	}


	/**
	* Creates a test case with the specified name and a default max fail count.
	*
	* @param name 		 the name of the test case
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractIntegratedTestCase(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a test case with the specified name and max fail count.
	*
	* @param name 		 the name of the test case
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractIntegratedTestCase(java.lang.String name, int maxFailCount)
	{
		 super();
	}


	/**
	* Returns the UltraLightClient application class. If the method returns
	* <code>null</code>, the application class is taken from the
application
	* configuration file.
	*
	* @return		the UltraLightClient application class
	**/
	 protected java.lang.Class getApplicationClass()
	{
		return null;
	}


	/**
	* Initializes the application configuration if getApplicationClass() returns
	* <code>null</code>. If getApplicationClass() returns not
<code>null</code>,
	* {@link AbstractTestCase} handleConfiguration is called.
	*
	**/
	 protected void handleConfiguration()
	{
	}


	/**
	* Subclasses can overwrite this method to return the resource name of the
	* configuration file to configure the testcase. If
<code>null</code> is
	* returnedthe default application configuration file
	* (ULCApplicationConfiguration.xml) is used.
	*
	* @return		<code>null</code>.
	**/
	 protected java.lang.String getConfigurationResourceName()
	{
		return null;
	}


}