package com.ulcjava.testframework;


	/**
	* Abstract base class for all test cases. Before executing a test the following
	* is configured:
<ul>
<li>The test output is set to a NullOutput by
	* default.</li>
<li>The timeouts are decreased. The timeouts can be configured
	* by providing a property file named jemmyTimeout.properties, which is
located
	* on the classpath.</li>
<li>The dispatching model is set to the
	* JemmyProperties.QUEUE_MODEL_MASK by default.</li>
<li>The drivers from the
	* {@link TestFrameworkDriverInstaller} are installed.</li>
</ul>
The default
	* configuration can be overwritten by specifying own configuration inside the
	* setup method (for all test methods class) or
inside a test method.
	*
	**/
 public  abstract class AbstractTestCase extends junit.framework.TestCase
{

	/**
	* The default max fail count.
	*
	**/
	 public  final  static int DEFAULT_MAX_FAIL_COUNT = 0;


	/**
	* Creates a test case with no name and a default max fail count.
	*
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractTestCase()
	{
		 super();
	}


	/**
	* Creates a test case with no name and the specified max fail count.
	*
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractTestCase(int maxFailCount)
	{
		 super();
	}


	/**
	* Creates a test case with the specified name and a default max fail count.
	*
	* @param name 		 the name of the test case
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractTestCase(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a test case with the specified name and max fail count.
	*
	* @param name 		 the name of the test case
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractTestCase(java.lang.String name, int maxFailCount)
	{
		 super();
	}

	 public void runBare()throws java.lang.Throwable
	{
	}


	/**
	* Disables the application configuration. Subclasses can overwrite this method
	* torun tests with a configuration read from a XML file.
	*
	* @see		ApplicationConfiguration
	**/
	 protected void handleConfiguration()
	{
	}


	/**
	* Returns the max fail count.
	*
	* @return		the max fail count
	**/
	 public int getMaxFailCount()
	{
		return 0;
	}


	/**
	* Returns the current fail count.
	*
	* @return		the current fail count
	**/
	 public int getFailCount()
	{
		return 0;
	}


	/**
	* Increments the fail count of the currently executed test case
	*
	**/
	 public void incrementFailCount()
	{
	}


	/**
	* Returns the current step count of the test case
	*
	* @return		current step count
	**/
	 public int getStepCount()
	{
		return 0;
	}


	/**
	* Increments the current step count
	*
	**/
	 public void incrementStepCount()
	{
	}


	/**
	* Factory method that creates the client test environment adapter.
	*
	* @deprecated		Subclasses should use setTestEnvironmentAdapterProvider to configure the environment of the test case
	* @return		the client test environment adapter
	**/
	 protected com.ulcjava.testframework.IClientTestEnvironmentAdapter createClientTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* Factory method that creates the server test environment adapter.
	*
	* @deprecated		Subclasses should use setTestEnvironmentAdapterProvider to configure the environment of the test case
	* @return		the server test environment adapter
	**/
	 protected com.ulcjava.testframework.IServerTestEnvironmentAdapter createServerTestEnvironmentAdapter()
	{
		return null;
	}

	 protected void setUp()throws java.lang.Exception
	{
	}


	/**
	* Returns the classname of the L&F to be set for the test. Subclasses can
	* overwrite this method to return another value
	* than
UIManager.getCrossPlatformLookAndFeelClassName()
	*
	* @return		the classname for the L&F of testcase.
	**/
	 protected java.lang.String getLookAndFeelClassname()
	{
		return null;
	}

	 protected void tearDown()throws java.lang.Exception
	{
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>boolean</code>.
	*
	* @param command 		 the test command
	* @return		the boolean result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public boolean runBooleanCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return false;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>boolean</code>.
	*
	* @param command 		 the test command
	* @return		the boolean result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public byte runByteCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>char</code>.
	*
	* @param command 		 the test command
	* @return		the char result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public char runCharCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 'a';
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>double</code>.
	*
	* @param command 		 the test command
	* @return		the double result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public double runDoubleCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0.0d;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>float</code>.
	*
	* @param command 		 the test command
	* @return		the float result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public float runFloatCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0.0f;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>int</code>.
	*
	* @param command 		 the test command
	* @return		the int result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public int runIntCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>long</code>.
	*
	* @param command 		 the test command
	* @return		the long result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public long runLongCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0L;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>Object</code>.
	*
	* @param command 		 the test command
	* @return		the Object result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public java.lang.Object runObjectCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return null;
	}


	/**
	* Runs the given command in the test context and returns the resulting
	* <code>short</code>.
	*
	* @param command 		 the test command
	* @return		the short result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public short runShortCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
		return 0;
	}


	/**
	* Runs the given command in the test context.
	*
	* @param command 		 the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public void runVoidCommand(com.ulcjava.testframework.TestCommand command)throws com.ulcjava.testframework.ProceedException
	{
	}


	/**
	* 
	*
	* @return		the TestEnvironmentAdapterProvider the test works with.
	**/
	 public com.ulcjava.testframework.ITestEnvironmentAdapterProvider getTestEnvironmentAdapterProvider()
	{
		return null;
	}


	/**
	* Sets the test environment. This should be done before the test is started.
	*
	* @param environment 		 the TestEnvironment in which the test is to be run
	**/
	 public void setTestEnvironmentAdapterProvider(com.ulcjava.testframework.ITestEnvironmentAdapterProvider environment)
	{
	}


	/**
	* Creates a test suite from the class for every enviroment in the array.
	*
	* @param testClass 		 class of the {@link AbstractTestCase} to be run in the different environments.
	* @param environments 		 array of ITestEnvironmentAdapterProvider in which the tests are to be run.
	* @return		a test suite with tests for the different environments
	**/
	 public  static junit.framework.TestSuite createSuiteForEnvironments(java.lang.Class testClass, com.ulcjava.testframework.ITestEnvironmentAdapterProvider[] environments)
	{
		return null;
	}


	/**
	* creates a test suite containing a suite for the given test case in each test
	* environment that runs the client and the server side
within the same VM
	* (Development Runner, Applet/Jnlp/Standalone against Jetty). The testClass
	* should be a descendant of
{@link AbstractTestCase} otherwise the test
	* environment won't be setup correctly.
	*
	* @param testClass 		 class of the {@link AbstractTestCase} to be run in the different environments.
	* @param applicationClass 		 class of the {@link IApplication} to be started for the tests.
	* @return		a test suite holding tests for all integrated tests environment.
	**/
	 public  static junit.framework.TestSuite createSuiteForAllIntegratedEnvironments(java.lang.Class testClass, java.lang.Class applicationClass)
	{
		return null;
	}


	/**
	* creates a test suite containing a suite for the given test case in each test
	* environment that runs the client and the server side
within the same VM
	* (Development Runner, Applet/Jnlp/Standalone against Jetty). The
	* testThatImplementsIApplicationClass should be a
descendant of {@link
	* AbstractTestCase} and must implement {@link IApplication} otherwise the test
	* environment won't be setup
correctly.
	*
	* @param testThatImplementsIApplicationClass 		 class of the {@link AbstractTestCase} that implements IApplication.
	* @return		a test suite holding tests for all integrated tests environment.
	**/
	 public  static junit.framework.TestSuite createSuiteForAllIntegratedEnvironments(java.lang.Class testThatImplementsIApplicationClass)
	{
		return null;
	}


	/**
	* creates a test suite containing a suite for the given test case in each test
	* environment that runs against a deployed application
(Applet,Jnlp and
	* Standalone). The testClass should be a descendant of {@link AbstractTestCase}
	* otherwise the test environment won't
be setup correctly.
	*
	* @param testClass 		 class of the {@link AbstractTestCase} to be run in the different environments.
	* @param urlString 		 of the ULC-Application, which the tests are running against.
	* @return		a test suite holding tests for all remote tests environment.
	**/
	 public  static junit.framework.TestSuite createSuiteForAllRemoteEnvironments(java.lang.Class testClass, java.lang.String urlString)
	{
		return null;
	}


}