package com.ulcjava.testframework;


	/**
	* Adapts a client test environment for the UltraLightClient test framework.
	*
	**/
 public interface IClientTestEnvironmentAdapter
{


	/**
	* Sets up the client test environment. The UltraLightClient test framework
	* invokes this method before a test run.
	*
	* @throws		Exception
	**/
	void setUpClient()throws java.lang.Exception;

	/**
	* Tears down the client test environment. The UltraLightClient test framework
	* invokes this method after a test run.
	*
	* @throws		Exception
	**/
	void tearDownClient()throws java.lang.Exception;

	/**
	* Invokes a piece of code in the context of the client test environment.
	*
	* @param runnable 		 the piece of code to execute
	**/
	void invokeClient(java.lang.Runnable runnable);

}