package com.ulcjava.testframework;


	/**
	* Adapts a server test environment for the UltraLightClient test framework.
	*
	**/
 public interface IServerTestEnvironmentAdapter
{


	/**
	* Sets up the server test environment. The UltraLightClient test framework
	* invokes this method before a test run. <br>
POSTCONDITION: The server is
	* running and accepts requests.
	*
	* @throws		Exception
	**/
	void setUpServer()throws java.lang.Exception;

	/**
	* Tears down the server test environment. The UltraLightClient test framework
	* invokes this method after a test run. <br>
POSTCONDITION: The server is not
	* running anymore and all resources are freed, such that starting the server
	* again is possible.
	*
	* @throws		Exception
	**/
	void tearDownServer()throws java.lang.Exception;

	/**
	* 
	*
	* @return		the server side ULCSession in which the test case runs
	**/
	com.ulcjava.base.server.ULCSession getSession();

}