package com.ulcjava.testframework;


	/**
	* <code>TestCommand</code> can be used to run a piece of code in the test
	* context. The piece of code may produce a result or an
throwable.
	*
	* @see		TestContext
	**/
 public  abstract class TestCommand extends java.lang.Object
{


	/**
	* Creates a test command.
	*
	**/
	 public TestCommand()
	{
		 super();
	}


	/**
	* Returns the result of the executed command.
	*
	* @return		the result of the executed command
	**/
	 public java.lang.Object getResult()
	{
		return null;
	}


	/**
	* Sets the result of the executed command.
	*
	* @param result 		 the result of the executed command
	**/
	 public void setResult(java.lang.Object result)
	{
	}


	/**
	* Returns the throwable for the executed command.
	*
	* @return		the throwable for the executed command
	**/
	 public java.lang.Throwable getThrowable()
	{
		return null;
	}


	/**
	* Set the throwable to be passed back to the caller of the TestCommand, if the
	* execution of the code throws an exception
	*
	* @param throwable 		 the Throwable thrown while executing the command's code.
	**/
	 protected void setThrowable(java.lang.Throwable throwable)
	{
	}


	/**
	* Starts the command inside the test context.
	*
	* @return		the result of the test command
	* @throws		ProceedException if the test command throws an exception
	**/
	 public java.lang.Object start()throws com.ulcjava.testframework.ProceedException
	{
		return null;
	}


	/**
	* Executes the piece of code inside the test command.
	*
	* @throws		Throwable
	**/
	 abstract  protected void proceed()throws java.lang.Throwable;

}