package com.ulcjava.testframework.jnlp;


	/**
	* Base class for writing simple Tests in the JNLP environment with minimal
	* effort. Everything is in the same file because the Test
implements the
	* application itself.

<pre>public class SimpleJNLPTestCase extends
	* AbstractSimpleJnlpTestCase {

private ULCLabel fLabel;

public void
	* testChangeLabel() throws Exception
	* {
TestContext.getInstance().runVoidCommand(new ServerSideCommand()
	* {
protectedvoid proceedOnServer() throws Throwable
	* {
fLabel.setText("Goodbye");
}

});

ULCLabelOperator labelOperator = new
	* ULCLabelOperator(fLabel);
assertEquals("Goodbye",
	* labelOperator.getText());

}
public void start() {
ULCFrame rootPane = new
	* ULCFrame("Hello World");
fLabel = new
	* ULCLabel("Hello");
rootPane.add(fLabel);rootPane.setVisible(true);
}

}</pre>
	*
	**/
 public  abstract class AbstractSimpleJnlpTestCase extends com.ulcjava.testframework.jnlp.AbstractJnlpTestCase implements com.ulcjava.base.application.IApplication
{


	/**
	* Creates a JNLP test case with no name and a default max fail count.
	*
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractSimpleJnlpTestCase()
	{
		 super();
	}


	/**
	* Creates a JNLP test case with no name and the specified max fail count.
	*
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractSimpleJnlpTestCase(int maxFailCount)
	{
		 super();
	}


	/**
	* Creates a JNLP test case with the specified name and a default max fail count.
	*
	* @param name 		 the name of the test case
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractSimpleJnlpTestCase(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a JNLP test case with the specified name and max fail count.
	*
	* @param name 		 the name of the test case
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractSimpleJnlpTestCase(java.lang.String name, int maxFailCount)
	{
		 super();
	}

	 final  protected java.lang.Class getApplicationClass()
	{
		return null;
	}

	 public void activate()
	{
	}

	 public void handleMessage(java.lang.String message)
	{
	}

	 public void passivate()
	{
	}

	 public void pause()
	{
	}

	 public void resume()
	{
	}

	 public void stop()
	{
	}


}