package com.ulcjava.testframework.standalone;


	/**
	* Abstract base class for all test cases that rely on the standalone and remote
	* server test environment.
	*
	**/
 public  abstract class AbstractStandaloneRemoteServerTestCase extends com.ulcjava.testframework.AbstractRemoteTestCase
{


	/**
	* Creates a standalone test case that connects to a remote server with no name
	* and a default max fail count.
	*
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractStandaloneRemoteServerTestCase()
	{
		 super();
	}


	/**
	* Creates a standalone test case that connects to a remote server with no name
	* and the specified max fail count.
	*
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractStandaloneRemoteServerTestCase(int maxFailCount)
	{
		 super();
	}


	/**
	* Creates a standalone test case that connects to a remote server with the
	* specified name and a default max fail count.
	*
	* @param name 		 the name of the test case
	* @see		#DEFAULT_MAX_FAIL_COUNT
	**/
	 protected AbstractStandaloneRemoteServerTestCase(java.lang.String name)
	{
		 super();
	}


	/**
	* Creates a standalone test case that connects to a remote server with the
	* specified name and max fail count.
	*
	* @param name 		 the name of the test case
	* @param maxFailCount 		 the max fail count of the test case
	**/
	 protected AbstractStandaloneRemoteServerTestCase(java.lang.String name, int maxFailCount)
	{
		 super();
	}


	/**
	* 
	*
	* @deprecated		use configure(StandaloneTestEnvironmentAdapter clientAdapter) to customize the StandaloneTestEnvironmentAdapter
	**/
	 protected  final com.ulcjava.testframework.IClientTestEnvironmentAdapter createClientTestEnvironmentAdapter()
	{
		return null;
	}


	/**
	* Factory method that creates the standalone test environment adapter.
	*
	* @deprecated		use configure(StandaloneTestEnvironmentAdapter clientAdapter) to customize the StandaloneTestEnvironmentAdapter
	* @param urlString 		 the URL string of the remote UltraLightClient application
	* @return		the standalone test environment adapter
	**/
	 protected com.ulcjava.testframework.standalone.StandaloneTestEnvironmentAdapter createStandaloneTestEnvironmentAdapter(java.lang.String urlString)
	{
		return null;
	}


	/**
	* overwrite in subclasses to configure the Standalone
	* ClientTestEnvironmentAdapter with for example own Launchers etc.
	*
	* @param clientAdapter 		 the StandaloneTestEnvironmentAdapter to be configured
	**/
	 protected void configure(com.ulcjava.testframework.standalone.StandaloneTestEnvironmentAdapter clientAdapter)
	{
	}


}