package com.ulcjava.base.client;


	/**
	* Implement this interface to enable a client-side proxy to update the state of
	* the corresponding server-side component during the next
round-trip. Such a
	* situation arises when there is a state change on the client component due to
	* auser interaction like window resizing,
button selection state, enabled
	* state,etc. The client-side proxy needs to register an object of the class
	* implementing
<code>IDirtyDataOwner</code> interface with the
	* <code>UISession</code> using <code>getSession().addDirtyDataOwner()</code>.
	* During
the next round-trip, before sending other requests,
	* <code>flushDirtyData()</code> is called on all
	* <code>IDirtyDataOwner</code>s,
wherein they can update the state of the
	* server-side widget using:
<code>updateStateULC("<attributeName>",
	* getBasicComponent().get<AttributeName>())</code>. The
	* <code>updateStateULC()</code> calls
are handled and dispatched on the
	* server-side component by its <code>ULCProxyDispatcher</code>. After a
	* round-trip all
<code>IDirtyDataOwners</code> are removed from the
	* <code>UISession</code>. Therefore, the client-side proxy must register
	* an
<code>IDirtyDataOwner</code> with the <code>UISession</code> every time
	* itsstate changes, i.e. every time it becomes "dirty".
<p>
</p>
It should be
	* noted that the client-side proxy should not mark itself as dirty, i.e. it
	* should not add a <code>IDirtyDataOwner</code> to
<code>UISession</code>, when
	* its state is being changed as a result of a state change on the server-side
	* proxy. A client-side proxy's
state gets synchronized with its server-side
	* proxy while the client is processing requests (responses) from the server,
	* which can be
identified by the condition:
	* <code>getSession().isHandlingRequest()</code>. In such a situation, the
	* client-side state will be the
same as the server-side state and hence no
	* synchronization is needed from client to
	* server.
<p>
</p>
<b>Examples</b>
<p>
</p>
The following code shows how
	* <code>ULCSlider</code>'s client-side proxy synchronizes its value to the
	* server-side proxy.

<pre>
// Client side class
public class UISlider extends
	* UIComponent implements ChangeListener, IDirtyDataOwner,
	* IUserInteractionListener {

...

// flush the value of the slider to the
	* server side proxy
public void flushDirtyData() {
updateStateULC("value",
	* getBasicSlider().getValue());
}

// method fired when value on the slider
	* changes
public void stateChanged(ChangeEvent e) {
if
	* (!getSession().isHandlingRequest()) { // not a state change on server
// Add
	* self as dirty data owner
getSession().addDirtyDataOwner(this);
// send the
	* value changed event to server
fireValueChangedULC();
}
}
}

// Server side
	* class
public class ULCSlider extends ULCComponent {

...

protected void
	* updateValue(int value) {
fValue = value;
}

protected class
	* ULCSliderDispatcher extends ULCComponentDispatcher {
public final void
	* updateValue(int value)
	* {
ULCSlider.this.updateValue(value);
}
}
}
</pre>

<p>
</p>
	*
	* @ulc.extension		
	* @see		com.ulcjava.base.client.UISession
	**/
 public interface IDirtyDataOwner
{


	/**
	* Flush dirty data to update the state of the server side component.
	*
	**/
	 public void flushDirtyData();

}