package com.ulcjava.base.client;


	/**
	* The feedback strategy determines the user feedback for a blocked session.
	*
	**/
 public interface IUserFeedbackStrategy
{


	/**
	* Invoked when a session just has been blocked.
	*
	* @param session 		 the blocked session
	**/
	 public void startBlockingFeedback(com.ulcjava.base.client.UISession session);

	/**
	* Invoked when a session just has been unblocked.
	*
	* @param session 		 the unblocked session
	**/
	 public void stopBlockingFeedback(com.ulcjava.base.client.UISession session);

	/**
	* Invoked when user input has been blocked.
	*
	* @param session 		 the session for which user feedback has been blocked
	* @param event 		 the event that has been blocked
	**/
	 public void giveUserInputBlockedFeedback(com.ulcjava.base.client.UISession session, java.awt.AWTEvent event);

}