package com.ulcjava.base.client;


	/**
	* This is the listener interface for notification from the
	* UserInteractionMonitor. The class that is interested in observing the
	* beginning
and end of an user interaction on a component implements this
	* interface. The object created with that class is registered with
	* the
<code>UserInteractionMonitor</code> that is monitoring the component.
	* <code>UserInteractionMonitor</code>
	* notifies
<code>IUserInteractionListener</code>s with
	* <code>fireUserInteractionStarted()</code> whenever a user interaction begins
	* and with
<code>fireUserInteractionEnded()</code> whenever the interaction ends.
	*
	* @ulc.extension		
	* @see		com.ulcjava.base.client.UserInteractionMonitor
	**/
 public interface IUserInteractionListener
{


	/**
	* Invoked when an user interaction starts.
	*
	**/
	 public void userInteractionStarted();

	/**
	* Invoked when an user interaction ends.
	*
	**/
	 public void userInteractionEnded();

}