package com.ulcjava.base.client;


	/**
	* This is the common superclass of all client-side UI half-objects. It provides
	* common functionality for restoring the half-object's state
during upload, for
	* handling requests coming from the corresponding server-side ULC object and
	* forsending requests to the corresponding
server-side ULC object.
	*
	* @ulc.extension		
	**/
 public  abstract class UIProxy extends java.lang.Object implements com.ulcjava.base.shared.IDefaults, com.ulcjava.base.shared.ICallable
{


	/**
	* Creates a <code>UIProxy</code> object.
	*
	* @ulc.extension		
	**/
	 public UIProxy()
	{
		 super();
	}


	/**
	* Converts an <code>Anything</code> object into what the <code>Anything</code>
	* object contains or describes. If the passed in
<code>Anything</code> object
	* describes a UI half-object, then this half object is potentially created from
	* the given description. The
resulting UI half object is returned. If the
	* passedin <code>Anything</code> object does not describe a UI half-object,
	* thenthe
contents of the <code>Anything</code> object is returned using {@link
	* Anything#toObject()}.
	*
	* @param anything 		 the <code>Anything</code> object to converted
	* @return		the result of the conversion
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder} to
send custom objects between server and client instead. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	* @ulc.extension		
	**/
	 public java.lang.Object convert(com.ulcjava.base.shared.internal.Anything anything)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder} to
send custom objects between server and client instead. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	**/
	 public com.ulcjava.base.shared.internal.Anything convert(java.lang.Object object)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder} to
send custom objects between server and client instead. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	**/
	 protected java.awt.Color convertColorFromAnything(com.ulcjava.base.shared.internal.Anything anything)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder} to
send custom objects between server and client instead. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	**/
	 protected com.ulcjava.base.client.UIIcon convertUIIconFromAnything(com.ulcjava.base.shared.internal.Anything anything)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder} to
send custom objects between server and client instead. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	**/
	 protected java.awt.Insets convertInsetsFromAnything(com.ulcjava.base.shared.internal.Anything anything)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder} to
send custom objects between server and client instead. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	**/
	 protected java.awt.Dimension convertDimensionFromAnything(com.ulcjava.base.shared.internal.Anything anything)
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style object serialization/deserialization mechanism based on {@link com.ulcjava.base.shared.IStreamCoder} to
send custom objects between server and client instead. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	**/
	 protected javax.swing.KeyStroke convertKeyStrokeFromAnything(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* Returns the unique identifier of this UI half-object.
	*
	**/
	 public int getId()
	{
		return 0;
	}


	/**
	* Handles a request originating from the server-side ULC half-object associated
	* with this UI object.
	*
	* @param request 		 the name of the request
	* @param args 		 the arguments of the request
	* @deprecated		Use the <code>ULCProxy.setStateUI(...)</code>, <code>ULCProxy.addStateUI(...)</code>
<code>ULCProxy.removeStateUI(...)</code> etc. methods on server-side instead and provide corresponding public client-side
setter methods for properties. (See the <a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC
Extension Guide</a> for more information.)
	**/
	 public void handleRequest(java.lang.String request, com.ulcjava.base.shared.internal.Anything args)
	{
	}


	/**
	* ULC processes all server side requests through this method.
	*
	* @param methodName 		 the name of the method to invoke
	* @param arguments 		 the arguments for the method call
	**/
	 public void processInvokeUI(java.lang.String methodName, java.lang.Object[] arguments)
	{
	}


	/**
	* Checks if this UI object is still registered at the client session.
	* (Deregistration might have happened because the server-side ULC
half object
	* associated with this UI object has been garbage collected and a release
	* request has been sent to the client and has been
processed there.)
	*
	* @return		<code>true</code> true if still registered, <code>false</code> otherwise
	* @ulc.internal		
	**/
	 protected boolean isRegistered()
	{
		return false;
	}


	/**
	* Restores the state originating from the server-side ULC half-object associated
	* with this UI half-object. The transferred state from
the ULC half-object was
	* saved in an <code>Anything</code> object via (an overriden version of)
	* <code>ULCProxy.saveState()</code>
during the upload of the ULC object.
	* <code>args</code> is the marshalled copy of that <code>Anything</code>
	* object.<code>args</code>
should be used in overriden versions of this method
	* in order to adjust the state of this UI object and therefore to complete
	* the
upload of the corresponding ULC object. <p/> Overriden versions of this
	* method should always invoke
<code>super.restoreState(...)</code> in order to
	* restore state that belongs to the superclass. <p/> This implementation
	* of
<code>restoreState(...)</code> already handles four restoring-aspects,
	* which are relevant during upload:
<ul>
<li>It enables the delivery of events
	* for server-side listeners, whereby these listeners where registered at the
	* corresponding ULC
object via <code>ULCProxy.addListener(...)</code>.
<li>It
	* enables the configuration of event delivery modes for event categories (which
	* were set via
<code>ULCProxy.setEventDeliveryMode(...)</code> before
	* upload).
<li>It performs state changes, which were recorded via
	* <code>ULCProxy.uploadStateUI()</code>
</ul>
	*
	* @param args 		 describes the marshalled state of the ULC half-object
	* @deprecated		Use {@link com.ulcjava.base.application.ULCProxy#uploadStateUI()} on server-side instead and provide corresponding public
client-side setter methods for properties. (See the <a
href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide</a> for more information.)
	**/
	 public void restoreState(com.ulcjava.base.shared.internal.Anything args)
	{
	}


	/**
	* Sends a (non-blocking) request with no arguments to the server side ULC object
	* corresponding to this UI object.
	*
	* @param request 		 the name of the request
	* @deprecated		Use new-style client-server communication mechanism via {@link #invokeULC(String)} instead.
	**/
	 public void sendULC(java.lang.String request)
	{
	}


	/**
	* Sends a deferred request to the server, which marks the proxy as collectable.
	*
	**/
	 public void sendMarkCollectableULC()
	{
	}


	/**
	* Sends a (non-blocking) request with one argument to the server side ULC object
	* corresponding to this UI object.
	*
	* @param request 		 the name of the request
	* @param args 		 the argument of the request
	* @deprecated		Use new-style client-server communication mechanism via {@link #invokeULC(String, Object[])} instead.
	**/
	 public void sendULC(java.lang.String request, com.ulcjava.base.shared.internal.Anything args)
	{
	}


	/**
	* Sends a blocking request with one argument to the server side ULC object
	* corresponding to this UI object. "Blocking" means that the
GUI is blocked
	* (does not react to user events) while the server roundtrip initiated by this
	* method call is in process. The blocking
ends, when the response from the
	* server that follows this request has been processed by the client.
	*
	* @param request 		 the name of the request
	* @param args 		 the argument of the request
	* @deprecated		Use new-style client-server communication mechanism via {@link #invokeULC(int, String, Object[])} instead.
	**/
	 public void sendBlockingULC(java.lang.String request, com.ulcjava.base.shared.internal.Anything args)
	{
	}


	/**
	* Sends a (non-blocking) request with a key-value pair as an argument to the
	* server side ULC object corresponding to this UI object.
	*
	* @param request 		 the name of the request
	* @param key 		 the key part of the argument
	* @param value 		 the value part of the argument
	* @deprecated		Use new-style client-server communication mechanism via {@link #invokeULC(String, Object[])} instead.
	**/
	 public void sendULC(java.lang.String request, java.lang.String key, com.ulcjava.base.shared.internal.Anything value)
	{
	}


	/**
	* 
	*
	* @ulc.internal		
	**/
	 public void setSessionAndId(com.ulcjava.base.client.UISession session, int oid)
	{
	}


	/**
	* Gets the client-side session to which this UI object belongs.
	*
	* @return		the client-side session
	**/
	 public com.ulcjava.base.client.UISession getSession()
	{
		return null;
	}


	/**
	* Checks if events of the given event category are enabled, so that they will
	* have to be sent to server because listeners are
registered for them at the
	* corresponding ULC object.
	*
	* @param eventCategory 		 the event category, for which to do the check
	* @return		<code>true</code> if enabled, <code>false</code> otherwise
	* @deprecated		Use {@link #isOptionalEventEnabled(String)} instead.
	**/
	 protected boolean isOptionalEventEnabled(int eventCategory)
	{
		return false;
	}


	/**
	* Checks if events of the given event category are enabled, so that they will
	* have to be sent to server because listeners are
registered for them at the
	* corresponding ULC object.
	*
	* @param eventCategory 		 the event category, for which to do the check
	* @return		<code>true</code> if enabled, <code>false</code> otherwise
	**/
	 protected boolean isOptionalEventEnabled(java.lang.String eventCategory)
	{
		return false;
	}


	/**
	* This method should only be called via the server.
	*
	* @ulc.internal		
	**/
	 public void addOptionalEventType(java.lang.String eventCategory)
	{
	}


	/**
	* This method should only be called via the server.
	*
	* @ulc.internal		
	**/
	 public void removeOptionalEventType(java.lang.String eventCategory)
	{
	}


	/**
	* This method should only be called via the server.
	*
	* @ulc.internal		
	**/
	 public void addEventDeliveryMode(java.lang.String eventCategory, int mode)
	{
	}


	/**
	* Returns the modifiers from the current AWTEvent. This method is needed because
	* the modifiers are lost for some action events because
of problems with the
	* FilteringEventQueue.
	*
	* @ulc.extension		
	**/
	 protected int getCurrentModifiers()
	{
		return 0;
	}


	/**
	* Sends an event to the server-side ULC object associated with this UI object,
	* given that a listener is registered for the event
category
	* <code>eventCategory</code> at the ULC object. The event does not obtain any
	* description details.
	*
	* @param eventCategory 		 the event category, for which the event should be delivered
	* @param eventId 		 an ID which identifies the event type. It is used to dispatch the event to the appropriate listener method of a
server-side listener object
	* @see		#sendOptionalEventULC(int, int, Anything)
	* @deprecated		Use new-style event delivery mechanism and {@link #fireEventULC(String, String, Object[])} instead.
	**/
	 protected void sendOptionalEventULC(int eventCategory, int eventId)
	{
	}


	/**
	* Fires an action event, if listeners are registered for the category {@link
	* UlcEventCategories#ACTION_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code> object.
	*
	* @param command 		 the command parameter for {@link com.ulcjava.base.application.event.ActionEvent} event to be created on the server
side
	* @param modifiers 		 the modifiers parameter for {@link com.ulcjava.base.application.event.ActionEvent} event to be created on the server
side
	**/
	 protected void fireActionPerformedULC(java.lang.String command, int modifiers)
	{
	}


	/**
	* Fires a selection event, if listeners are registered for the category {@link
	* UlcEventCategories#SELECTION_CHANGED_EVENT_CATEGORY} on
the server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.ISelectionChangedListener#selectionChanged(c
	* om.ulcjava.base.application.event.SelectionChangedEvent)}
.
	*
	**/
	 protected void fireSelectionChangedULC()
	{
	}


	/**
	* Fires a focus event, if listeners are registered for the category {@link
	* UlcEventCategories#FOCUS_EVENT_CATEGORY} on the
	* server-side
<code>ULCProxy</code> object associated with this
	* <code>UIProxy</code> object. The event will be delivered to the listener
	* method
{@link
	* com.ulcjava.base.application.event.IFocusListener#focusLost(com.ulcjava.base.ap
	* plication.event.FocusEvent)}.
	*
	**/
	 protected void fireFocusLostULC()
	{
	}


	/**
	* Fires a focus event, if listeners are registered for the category {@link
	* UlcEventCategories#FOCUS_EVENT_CATEGORY} on the
	* server-side
<code>ULCProxy</code> object associated with this
	* <code>UIProxy</code> object. The event will be delivered to the listener
	* method
{@link
	* com.ulcjava.base.application.event.IFocusListener#focusGained(com.ulcjava.base.
	* application.event.FocusEvent)}.
	*
	**/
	 protected void fireFocusGainedULC()
	{
	}


	/**
	* Fires a value changed event, if listeners are registered for the category
	* {@link UlcEventCategories#VALUE_CHANGED_EVENT_CATEGORY} on
the server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IValueChangedListener#valueChanged(com.ulcja
	* va.base.application.event.ValueChangedEvent)}.
	*
	**/
	 protected void fireValueChangedULC()
	{
	}


	/**
	* Fires a window event, if listeners are registered for the category {@link
	* UlcEventCategories#WINDOW_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IWindowListener#windowClosing(com.ulcjava.ba
	* se.application.event.WindowEvent)}.
	*
	**/
	 protected void fireWindowClosingULC()
	{
	}


	/**
	* Fires a window event, if listeners are registered for the category {@link
	* UlcEventCategories#WINDOW_FOCUS_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IWindowFocusListener#windowGainedFocus(com.u
	* lcjava.base.application.event.WindowEvent)}.
	*
	**/
	 protected void fireWindowGainedFocusULC()
	{
	}


	/**
	* Fires a window event, if listeners are registered for the category {@link
	* UlcEventCategories#WINDOW_FOCUS_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IWindowFocusListener#windowLostFocus(com.ulc
	* java.base.application.event.WindowEvent)}.
	*
	**/
	 protected void fireWindowLostFocusULC()
	{
	}


	/**
	* Fires a key event, if listeners are registered for the category {@link
	* UlcEventCategories#KEY_EVENT_CATEGORY} on the
	* server-side
<code>ULCProxy</code> object associated with this
	* <code>UIProxy</code> object. The event will be delivered to the listener
	* method
{@link
	* com.ulcjava.base.application.event.IKeyListener#keyTyped(com.ulcjava.base.appli
	* cation.event.KeyEvent)}.
	*
	**/
	 protected void fireKeyTypedULC(char c, int modifiers)
	{
	}


	/**
	* Fires an adjustment event, if listeners are registered for the category {@link
	* UlcEventCategories#ADJUSTMENT_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IAdjustmentListener#adjustmentValueChanged(c
	* om.ulcjava.base.application.event.AdjustmentEvent)}
.
	*
	**/
	 protected void fireAdjustmentValueChangedULC()
	{
	}


	/**
	* Fires a popup menu event, if listeners are registered for the category {@link
	* UlcEventCategories#POPUP_MENU_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IPopupMenuListener#popupMenuHasBecomeVisible
	* (com.ulcjava.base.application.event.PopupMenuEvent)}
.
	*
	**/
	 protected void firePopupMenuHasBecomeVisibleULC()
	{
	}


	/**
	* Fires a popup menu event, if listeners are registered for the category {@link
	* UlcEventCategories#POPUP_MENU_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IPopupMenuListener#popupMenuHasBecomeInvisib
	* le(com.ulcjava.base.application.event.PopupMenuEvent)}
.
	*
	**/
	 protected void firePopupMenuHasBecomeInvisibleULC()
	{
	}


	/**
	* Fires a popup menu event, if listeners are registered for the category {@link
	* UlcEventCategories#POPUP_MENU_EVENT_CATEGORY} on the
server-side
	* <code>ULCProxy</code> object associated with this <code>UIProxy</code>
	* object.The event will be delivered to the
listener method
{@link
	* com.ulcjava.base.application.event.IPopupMenuListener#popupMenuCanceled(com.ulc
	* java.base.application.event.PopupMenuEvent)}.
	*
	**/
	 protected void firePopupMenuCanceledULC()
	{
	}


	/**
	* Fires an event and potentially send it to the server-side
	* <code>ULCProxy</code>object associated with this <code>UIProxy</code>
object.
	* The event will be sent, if at least one listener is registered for the
	* category <code>eventCategory</code> on the respective
server-side
	* <code>ULCProxy</code>. The listeners must have been registered via
{@link
	* com.ulcjava.base.application.ULCProxy#addListener(String, EventListener)}
	* with<code>eventCategory</code> as the first
argument.
<p>
</p>
If an event is
	* sent, it is processed in the following way on the server side:
<ul>
<li>The
	* <code>ULCProxy</code> object tries to find a create method for creating the
	* corresponding server-side event on the
{@link
	* com.ulcjava.base.server.IDispatcher} associated with the
	* <code>ULCProxy</code>object.
<ul>
<li>The searched method must have the name
	* <code>create&lt;Xyz&gt;Event</code> where &lt;Xyz&gt; is the string contained
	* in
<code>eventCategory</code> with the first letter capitalized. E.g., if
	* <code>eventCategory</code> refers to the string
<code>action</code>, then the
	* create method name is <code>createActionEvent</code>.
<li>The parameter list
	* for the create method is given by the runtime types of the elements contained
	* in
<code>createEventArguments</code>. The rules for finding a related unique
	* create method with a corresponding parameter types is the
same as in the case
	* of {@link #invokeULC(String, Object[])}.
<li>The create method is expected to
	* return an object of type {@link java.util.EventObject} or <code>null</code>.
	* It is invoked with
the elements of <code>createEventArguments</code> as the
	* argument list. If the returned result is not <code>null</code>, then it
	* used
for further processing. Otherwise the server-side processing ends at
	* thispoint.
</ul>
<li>If the result of the create method call is not
	* <code>null</code>, then the returned {@link java.util.EventObject} is passed
	* on to
a process event method. The <code>ULCProxy</code> object tries to find
	* the process event method for processing the corresponding
server-side event
	* onthe {@link com.ulcjava.base.server.IDispatcher} associated with the
	* <code>ULCProxy</code> object.
<ul>
<li>The searched process event method must
	* have the name <code>process&lt;Xyz&gt;Event</code> where &lt;Xyz&gt; is the
	* string
contained in <code>eventCategory</code> with the first letter
	* capitalized. E.g. if <code>eventCategory</code> refers to the
	* string
<code>action</code>, then the create method name is
	* <code>processActionEvent</code>.
<li>The parameter list of the process event
	* method is
<code>(String eventCategory, String listenerMethodName, &lt;subtype
	* of EventObject&gt; eventObject)</code>, where the created event
must be
	* assignable to <code>&lt;subtype of EventObject&gt;</code>.
<li>In most cases
	* the process event is expected to invoke
{@link
	* com.ulcjava.base.application.ULCProxy#dispatchEvent(String, String,
	* EventObject)} in order to pass on the event to registered
listeners.
	* (However,sometimes it might be suitable to perform more or other tasks in
	* thiscontext.)
</ul>
</ul>
</p>
	*
	* @param eventCategory 		 the event category associated with the event to be delivered
	* @param listenerMethodName 		 the name of the listener method to be invoked on the listener interface when delivering the server-side
event via {@link com.ulcjava.base.application.ULCProxy#dispatchEvent(String, String, EventObject)}
	* @param createEventArguments 		 the argument list of the create event method to be invoked on the server side
	* @see		com.ulcjava.base.application.ULCProxy#addListener(String, EventListener)
	**/
	 protected void fireEventULC(java.lang.String eventCategory, java.lang.String listenerMethodName, java.lang.Object[] createEventArguments)
	{
	}


	/**
	* Fires an event and always send it to the server-side <code>ULCProxy</code>
	* object associated with this <code>UIProxy</code> object.
The event will be
	* sent, even if no listeners are registered for the category
	* <code>eventCategory</code> on the the respective
server-side
	* <code>ULCProxy</code>. Apart from this the method is identical to {@link
	* #fireEventULC(String, String, Object[])}.
	*
	* @see		#fireEventULC(String, String, Object[])
	**/
	 protected void fireMandatoryEventULC(java.lang.String eventCategory, java.lang.String listenerMethodName, java.lang.Object[] createEventArguments)
	{
	}


	/**
	* Returns the event delivery mode for the specified <code>eventCategory</code>
	* for this proxy. If no event delivery mode has been
specified on server side,
	* it returns the default event delivery mode {@link
	* #getDefaultEventDeliveryMode()}. The event delivery mode
is one of the
	* following
	* values:
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEventConstants.
	* ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
	*
	* @param eventCategory 		 the specified event category. Event categories are defined in UlcEventCategories.
	* @return		the event delivery mode for the event category for this proxy.
	* @see		com.ulcjava.base.shared.UlcEventCategories
	* @deprecated		Use {@link #getEventDeliveryMode(String)} instead.
	**/
	 protected int getEventDeliveryMode(int eventCategory)
	{
		return 0;
	}


	/**
	* Returns the event delivery mode for the specified <code>eventCategory</code>
	* for this proxy. If no event delivery mode has been
specified on server side,
	* it returns the default event delivery mode {@link
	* #getDefaultEventDeliveryMode()
getDefaultEventDeliveryMode}. The event
	* delivery mode is one of the following
	* values:
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEventConstants.
	* ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
	*
	* @param eventCategory 		 the specified event category. Event categories are defined in UlcEventCategories.
	* @return		the event delivery mode for the event category for this proxy.
	* @ulc.extension		
	* @see		com.ulcjava.base.shared.UlcEventCategories
	**/
	 protected  final int getEventDeliveryMode(java.lang.String eventCategory)
	{
		return 0;
	}


	/**
	* Returns the default event delivery mode for all events of this proxy. <p/>
	* Override this method, if you want to change the default
behaviour of a proxy.
	* The event delivery mode has to be one of the following
	* values:
<ul>
<li>UlcEventConstants.SYNCHRONOUS_MODE</li>
<li>UlcEventConstants.
	* ASYNCHRONOUS_MODE</li>
<li>UlcEventConstants.DEFERRED_MODE</li>
</ul>
<p>
</p>
<
	* b>Note: </b> You also must override {@link
	* com.ulcjava.base.application.ULCProxy#getDefaultEventDeliveryMode() }.
	*
	* @return		UlcEventConstants.SYNCHRONOUS_MODE as default value for this proxy.
	**/
	 protected int getDefaultEventDeliveryMode()
	{
		return 0;
	}


	/**
	* Sends an event to the server-side ULC object associated with this UI object,
	* given that a listener is registered for the event
category
	* <code>eventCategory</code> at the ULC object.
	*
	* @param eventCategory 		 the event category, for which the event should be delivered
	* @param eventId 		 an ID which identifies the event type. It is used to dispatch the event to the appropriate listener method of a
server-side listener object
	* @param args 		 the <code>Anything</code> object describing the event details
	* @deprecated		Use new-style event delivery mechanism and {@link #fireEventULC(String, String, Object[])} instead.
	**/
	 protected void sendOptionalEventULC(int eventCategory, int eventId, com.ulcjava.base.shared.internal.Anything args)
	{
	}


	/**
	* 
	*
	* @ulc.internal		
	* @deprecated		Use {@link #fireModelUpdateULC()} instead.
	**/
	 protected void sendOptionalModelUpdateULC()
	{
	}


	/**
	* 
	*
	* @ulc.internal		
	**/
	 protected void fireModelUpdateULC()
	{
	}


	/**
	* 
	*
	* @ulc.internal		
	**/
	 public void dispose()
	{
	}


	/**
	* This method returns the basic widget instance as <code>Object</code> type.
	* <p/>Developers who want to create their own or extended
widget should
	* implement the following convenience method in their class which extends from
	* <code>UIProxy</code> or from a subclass of
it: <p/> <p/> <p/>
	* <p/>
<p>
</p>

<pre>
public &lt;i&gt;MyBasicObject&lt;/i&gt;
	* getBasic&lt;i&gt;MyBasicObject&lt;/i&gt;() {
return
	* (&lt;i&gt;MyBasicObject&lt;/i&gt;)getBasicObject();
}
</pre>
	*
	* @return		the instance of the basic widget as <code>Object</code> type
	**/
	 public java.lang.Object getBasicObject()
	{
		return null;
	}


	/**
	* Overriding versions of this method create an instance of the basic (client)
	* widget that is wrapped by the corresponding subclass of
<code>UIProxy</code>.
	*
	* @param args 		 data which is needed in order to create the basic object
	* @return		<code>null</code>, overriding versions of this method should return the newly created basic object instead
	* @deprecated		Use {@link #createBasicObject(Object[])} instead.
	**/
	 protected java.lang.Object createBasicObject(com.ulcjava.base.shared.internal.Anything args)
	{
		return null;
	}


	/**
	* Overriding versions of this method create an instance of the basic (client)
	* widget that is wrapped by the corresponding subclass of
<code>UIProxy</code>.
	* In ULC, a <code>UI<i>xxx</i></code> proxy always wraps a
	* <code>Basic<i>xxx</i></code> object by
	* invoking
<code>UI<i>xxx</i>.createBasicObject(Object[])</code>.
<p>
</p>
Develo
	* pers who want to create their own or extended widget should adhere to the
	* following rules:
<ul>
<li><b>Do override
	* <code>createBasicObject(Object[])</code></b> in your subclass that extends
	* from <code>UIProxy</code> or from a
subclass of it, in case you use your own
	* (extended) basic widget. It is strongly recommended that your own (extended)
	* basic widget
extends from the <code>Basic<i>xxx</i></code> class provided in
	* every <code>UI<i>xxx</i></code> proxy class from which you derive.
Otherwise,
	* important functionality from the original basic widget might get
	* lost.
<li><b>Do not override <code>createBasicObject(Object[])</code></b> in
	* your subclass that extends from <code>UIProxy</code> or from a
subclass of
	* it,in case you <b>do not</b> use your own or extended basic widget, but the
	* same basic widget that is already returned
by
	* <code>super.createBasicObject(Object[])</code>. This behaviour mainly applies
	* when you just want to add or change some
functionality of an existing UI
	* proxybut not on the underlying basic widget.
</ul>
The following pattern
	* showshow to override this method, if needed:
<p>
</p>

<pre>
protected Object
	* createBasicObject(Object[] args) {
return new MyBasicObject(args[0], args[1],
	* ...);
}
</pre>
<p>
</p>
The arguments <code>args</code> may be used for
	* constructing the basic widget. They are provided during upload by a
	* server-side calls
to {@link
	* com.ulcjava.base.application.ULCProxy#createStateUI(Object[])} inside
{@link
	* com.ulcjava.base.application.ULCProxy#uploadStateUI()}.
<p>
</p>
Note that
	* therestoration of uploaded server state may not be performed via {@link
	* #createBasicObject(Object[])}. </p>
<p>
</p>
When uploading a widget, the
	* following steps are performed in the given order:
<ol>
<li>An instance of the
	* <code>UIProxy</code> is created using a no-argument constructor.
<li>The
	* underlying basic widget is created via {@link #createBasicObject(Object[])}
	* and bound to the <code>UIProxy</code> object.
<li>{@link
	* #preInitializeState()} is called. It may be overriden to initialize the UI
	* proxy object before state coming from the
corresponding server-side ULC
	* objectis restored.
<li>{@link #restoreState(Anything)} restores uploaded
	* statecoming from the associated server-side ULC object.
<li>{@link
	* #postInitializeState()} is called. It may be overriden to initialize the UI
	* proxy object after server-side state has been
restored.
</ol>
</p>
	*
	* @param arguments 		 data which is needed in order to create the basic object
	* @return		<code>null</code>, overriding versions of this method should return the newly created basic object instead.
	**/
	 protected java.lang.Object createBasicObject(java.lang.Object[] arguments)
	{
		return null;
	}


	/**
	* Initiates the creation of this UI object and the restoring of the state
	* originating from the corresponding server-side ULC object.
	*
	* @param a 		 the <code>Anything</code> used for {@link #restoreState(Anything)}.
	* @ulc.internal		
	**/
	 public void init(com.ulcjava.base.shared.internal.Anything a)
	{
	}


	/**
	* This method acts as a callback to initialize a <code>UIProxy</code> instance
	* before the server side state is restored. It is invoked
after {@link
	* #createBasicObject(Object[])} has been called and before {@link
	* #restoreState(Anything)} is invoked.
<p>
</p>
This implementation does
	* nothing. Subclasses may override this method to provide custom behaviour. </p>
	*
	* @see		#createBasicObject(Object[]) for the order steps when uploading a UI object
	**/
	 protected void preInitializeState()
	{
	}


	/**
	* This method acts as a callback to initialize a <code>UIProxy</code> instance
	* after the server side state is restored. It is invoked
after {@link
	* #restoreState(Anything)} has been invoked.
<p>
</p>
This implementation does
	* nothing. Subclasses may override this method to provide custom behaviour. </p>
	*
	* @see		#createBasicObject(Object[]) for the order steps when uploading a UI object
	**/
	 protected void postInitializeState()
	{
	}


	/**
	* Checks whether ULC is currently in uploading phase for this
	* <code>UIProxy</code> object.
	*
	* @return		<code>true</code> if this <code>UIProxy</code> object is in its upload phase, <code>false</code> otherwise
	**/
	 protected  final boolean isInitializingState()
	{
		return false;
	}


	/**
	* Invokes a server side method on the <code>ULCProxy</code> object (or its
	* dispatcher) associated with this <code>UIProxy</code>
object. A call to this
	* method is equivalent to <code>invokeULC(methodName, new Object[0])</code>
	*
	* @param methodName 		 the name of the server-side method to be invoked
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final void invokeULC(java.lang.String methodName)
	{
	}


	/**
	* Invokes a server side method on the <code>ULCProxy</code> object (or its
	* dispatcher) associated with this <code>UIProxy</code>
object. A call to this
	* method is equivalent to <code>invokeULC(UlcEventConstants.ASYNCHRONOUS_MODE,
	* methodName, new Object[0])</code>
	*
	* @param methodName 		 the name of the server-side method to be invoked
	* @param arguments 		 the arguments for the server-side method invocation
	* @see		#invokeULC(int, String, Object[])
	**/
	 protected  final void invokeULC(java.lang.String methodName, java.lang.Object[] arguments)
	{
	}


	/**
	* Invokes a server side method on the <code>ULCProxy</code> object (or its
	* dispatcher) associated with this <code>UIProxy</code>
object. When trying to
	* invoke a related method on the server side, ULC first searches for a matching
	* public method on the dispatcher
class associated with the
	* <code>ULCProxy</code> object. If no matching method is found there, ULC
	* searches for a matching public
method on the corresponding
	* <code>ULCProxy</code> class.
<p>
</p>
The rules for finding a matching method
	* on the dispatcher class or on the corresponding <code>ULCProxy</code> class
	* are explained in
the <a href="">ULC Extension Guide</a>. The concepts of
	* dispatcher classes are in explained in
{@link
	* com.ulcjava.base.server.IDispatcher}. </p>
	*
	* @param deliveryMode 		 the delivery mode for the resulting request, one of {@link UlcEventConstants#SYNCHRONOUS_MODE},
{@link UlcEventConstants#ASYNCHRONOUS_MODE}, {@link UlcEventConstants#DEFERRED_MODE}
	* @param methodName 		 the name of the server-side method to be invoked
	* @param arguments 		 the arguments for the server-side method invocation
	* @see		<a href="http://www.canoo.com/ulc/developerzone/ULCExtensionGuide.pdf">ULC Extension Guide< /a>
	* @see		com.ulcjava.base.server.IDispatcher
	**/
	 public void invokeULC(int deliveryMode, java.lang.String methodName, java.lang.Object[] arguments)
	{
	}


	/**
	* Updates a server-side <code>boolean</code> property by calling the
	* corresponding <code>update...(boolean)</code> method on the
server-side
	* proxy.<p>
</p>
Let "x" be the name of a property. Then, the resulting
	* marshalling call of <code>updateX(boolean)</code> is equivalent
	* to
<code>invokeULC("updateX", new Object[] { new Boolean(newValue) })</code>.
	* Therefore, the respective server-side method to update the
property is
	* expected to have the signature <code>public void updateX(boolean)</code>
	* (either on the proxy itself or on its dispatcher
class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final boolean updateStateULC(java.lang.String propertyName, boolean newValue)
	{
		return false;
	}


	/**
	* Updates a server-side <code>char</code> property by calling the corresponding
	* <code>update...(char)</code> method on the server-side
proxy.
<p>
</p>
Let
	* "x"be the name of a property. Then, the resulting marshalling call of
	* <code>updateX(char)</code> is equivalent to
<code>invokeULC("updateX", new
	* Object[] { new Character(newValue) })</code>. Therefore, the respective
	* server-side method to update
the property is expected to have the signature
	* <code>public void updateX(char)</code> (either on the proxy itself or on
	* its
dispatcher class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final char updateStateULC(java.lang.String propertyName, char newValue)
	{
		return 'a';
	}


	/**
	* Updates a server-side <code>byte</code> property by calling the corresponding
	* <code>update...(byte)</code> method on the server-side
proxy.
<p>
</p>
Let
	* "x"be the name of a property. Then, the resulting marshalling call of
	* <code>updateX(byte)</code> is equivalent to
<code>invokeULC("updateX", new
	* Object[] { new Byte(newValue) })</code>. Therefore, the respective
	* server-sidemethod to update the
property is expected to have the signature
	* <code>public void updateX(byte)</code> (either on the proxy itself or on its
	* dispatcher
class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final byte updateStateULC(java.lang.String propertyName, byte newValue)
	{
		return 0;
	}


	/**
	* Updates a server-side <code>short</code> property by calling the corresponding
	* <code>update...(short)</code> method on the
server-side proxy.
<p>
</p>
Let
	* "x" be the name of a property. Then, the resulting marshalling call of
	* <code>updateX(short)</code> is equivalent to
<code>invokeULC("updateX", new
	* Object[] { new Short(newValue) })</code>. Therefore, the respective
	* server-side method to update the
property is expected to have the signature
	* <code>public void updateX(short)</code> (either on the proxy itself or on its
	* dispatcher
class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final short updateStateULC(java.lang.String propertyName, short newValue)
	{
		return 0;
	}


	/**
	* Updates a server-side <code>int</code> property by calling the corresponding
	* <code>update...(int)</code> method on the server-side
proxy.
<p>
</p>
Let "x"
	* be the name of a property. Then, the resulting marshalling call of
	* <code>updateX(int)</code> is equivalent to
<code>invokeULC("updateX", new
	* Object[] { new Integer(newValue) })</code>. Therefore, the respective
	* server-side method to update the
property is expected to have the signature
	* <code>public void updateX(int)</code> (either on the proxy itself or on its
	* dispatcher
class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final int updateStateULC(java.lang.String propertyName, int newValue)
	{
		return 0;
	}


	/**
	* Updates a server-side <code>double</code> property by calling the
	* corresponding<code>update...(double)</code> method on the
server-side
	* proxy.
<p>
</p>
Let "x" be the name of a property. Then, the resulting
	* marshalling call of <code>updateX(double)</code> is equivalent
	* to
<code>invokeULC("updateX", new Object[] { new Double(newValue) })</code>.
	* Therefore, the respective server-side method to update the
property is
	* expected to have the signature <code>public void updateX(double)</code>
	* (either on the proxy itself or on its dispatcher
class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final double updateStateULC(java.lang.String propertyName, double newValue)
	{
		return 0.0d;
	}


	/**
	* Updates a server-side <code>float</code> property by calling the corresponding
	* <code>update...(float)</code> method on the
server-side proxy.
<p>
</p>
Let
	* "x" be the name of a property. Then, the resulting marshalling call of
	* <code>updateX(float)</code> is equivalent to
<code>invokeULC("updateX", new
	* Object[] { new Float(newValue) })</code>. Therefore, the respective
	* server-side method to update the
property is expected to have the signature
	* <code>public void updateX(float)</code> (either on the proxy itself or on its
	* dispatcher
class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final float updateStateULC(java.lang.String propertyName, float newValue)
	{
		return 0.0f;
	}


	/**
	* Updates a server-side <code>long</code> property by calling the corresponding
	* <code>update...(long)</code> method on the server-side
proxy.
<p>
</p>
Let
	* "x"be the name of a property. Then, the resulting marshalling call of
	* <code>updateX(long)</code> is equivalent to
<code>invokeULC("updateX", new
	* Object[] { new Long(newValue) })</code>. Therefore, the respective
	* server-sidemethod to update the
property is expected to have the signature
	* <code>public void updateX(long)</code> (either on the proxy itself or on its
	* dispatcher
class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final long updateStateULC(java.lang.String propertyName, long newValue)
	{
		return 0L;
	}


	/**
	* Updates a server-side <code>String</code> property by calling the
	* corresponding<code>update...(String)</code> method on the
server-side
	* proxy.
<p>
</p>
Let "x" be the name of a property. Then, the resulting
	* marshalling call of <code>updateX(String)</code> is equivalent
	* to
<code>invokeULC("updateX", new Object[] { newValue })</code>. Therefore,
	* the respective server-side method to update the property is
expected to have
	* the signature <code>public void updateX(String)</code> (either on the proxy
	* itself or on its dispatcher class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final java.lang.String updateStateULC(java.lang.String propertyName, java.lang.String newValue)
	{
		return null;
	}


	/**
	* Updates a server-side <code>Object</code> property by calling the
	* corresponding<code>update...(Object)</code> method on the
server-side
	* proxy.
<p>
</p>
Let "x" be the name of a property. Then, the resulting
	* marshalling call of <code>updateX(Object)</code> is equivalent
	* to
<code>invokeULC("updateX", new Object[] { newValue })</code>. Therefore,
	* the respective server-side method to update the property is
expected to have
	* the signature <code>public void updateX(Object)</code> (either on the proxy
	* itself or on its dispatcher class).
	*
	* @param propertyName 		 the name of the property to be set on the server side
	* @param newValue 		 the new value of the property
	* @return		the new value <code>newValue</code>
	* @see		#invokeULC(String, Object[])
	**/
	 protected  final java.lang.Object updateStateULC(java.lang.String propertyName, java.lang.Object newValue)
	{
		return null;
	}


}