package com.ulcjava.base.shared;


	/**
	* A common super class for standard coder registry providers in ULC. It provides
	* a coder registry with standard ULC Mobile coders, which
are identical on the
	* client and on the server side. Coders for the following classes are
	* registeredat the returned coder registry:
<ul>
<li>{@link
	* Short}</li>
<li>{@link Integer}</li>
<li>{@link Long}</li>
<li>{@link
	* Float}</li>
<li>{@link Double}</li>
<li>{@link Boolean}</li>
<li>{@link
	* Character}</li>
<li>{@link Byte}</li>
<li>{@link
	* java.util.Date}</li>
<li>{@link java.util.Locale}</li>
<li>{@link
	* java.sql.Date}</li>
<li>{@link java.sql.Timestamp}</li>
<li>{@link
	* java.sql.Time}</li>
<li>{@link java.util.TimeZone}</li>
<li>{@link
	* java.util.SimpleTimeZone}</li>
<li>sun.util.calendar.ZoneInfo (available
	* sinceJava 1.4)</li>
<li>{@link java.math.BigInteger}</li>
<li>{@link
	* java.math.BigDecimal}</li>
<li>{@link java.util.ArrayList}</li>
<li>{@link
	* java.util.LinkedList}</li>
<li>{@link java.util.Vector}</li>
<li>{@link
	* java.util.HashSet}</li>
<li>{@link java.util.TreeSet}</li>
<li>{@link
	* java.util.HashMap}</li>
<li>{@link java.util.LinkedHashMap}</li>
<li>{@link
	* java.util.TreeMap}</li>
<li>{@link java.util.Properties}</li>
<li>{@link
	* Anything}</li>
<li>{@link FileChooserConfig}</li>
<li>{@link
	* FileChooserConfig.FileFilterConfig}</li>
<li>{@link SortOrder}</li>
</ul>
	*
	* @ulc.extension		
	**/
 public  abstract class AbstractCoderRegistryProvider extends java.lang.Object implements com.ulcjava.base.shared.ICoderRegistryProvider
{


	/**
	* Gets the coder registry with the above described set of standard coders.
	*
	**/
	 public com.ulcjava.base.shared.CoderRegistry getCoderRegistry()
	{
		return null;
	}


	/**
	* Initializes a coder registry in order to add coders. (The given implementation
	* of this method already registers a set of standard
coders. Override this
	* method to add more coders and call
	* <code>super.initializeRegistry(registry)</code> in the override in order
	* to
keep the adding of standard coders.
	*
	* @param registry 		 the registry to be initialized
	**/
	 protected void initializeRegistry(com.ulcjava.base.shared.CoderRegistry registry)
	{
	}


}