package com.ulcjava.base.shared;


	/**
	* Defines operations for reading primitive values from a stream that has been
	* written using
{@link com.ulcjava.base.shared.IDataOutputStream}. The reading
	* half of the ULC marshalling code interacts with the underlying
	* transport
channel via an instance of this interface.
<p>
</p>
Note that data
	* elements written via <code>IDataOutputStream</code> must be read back in the
	* same sequence and with the same types that
they were written. In other words,
	* for each <code>write</code><em>Type</em> call issued against the stream,
	* theremust be a
corresponding <code>read</code><em>Type</em> call specifying
	* the same type. The results of a <code>read</code><em>Type</em>
invocation
	* witha type different from the actual data type of the next data element in
	* thestream are undefined, as are the results of
all subsequent read operations
	* on the stream.
</p>
<p>
</p>
All methods in this interface throw an
	* <code>IOException</code> if the stream is found corrupted in some fashion,
	* forexample if the
control information in the stream is inconsistent or if the
	* implementation can determine with certainty that the data type requested by
	* a
read operation does not match the next data element in the
	* stream.
<p>
</p>
<strong>Instances of this interface are not
	* thread-safe.</strong> Clients must not share instance references among
	* threadsand should in
fact not retain references beyond the scope of the
	* methodto which the reference was passed. Instances may refer to thread-local
	* or
otherwise volatile state and will behave in an unspecified fashion if
	* accessed outside the method invocation to which the reference
	* was
provided.
</p>
	*
	* @ulc.extension		
	**/
 public interface IDataInputStream
{


	/**
	* Reads a <code>boolean</code> value from this stream. The value must have been
	* written via
{@link IDataOutputStream#writeBoolean(boolean)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public boolean readBoolean()throws java.io.IOException;

	/**
	* Reads a <code>byte</code> value from this stream. The value must have been
	* written via {@link IDataOutputStream#writeByte(byte)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public byte readByte()throws java.io.IOException;

	/**
	* Reads a <code>char</code> value from this stream. The value must have been
	* written via {@link IDataOutputStream#writeChar(char)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public char readChar()throws java.io.IOException;

	/**
	* Reads a <code>short</code> value from this stream. The value must have been
	* written via {@link IDataOutputStream#writeShort(short)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public short readShort()throws java.io.IOException;

	/**
	* Reads an <code>int</code> value from this stream. The value must have been
	* written via {@link IDataOutputStream#writeInt(int)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public int readInt()throws java.io.IOException;

	/**
	* Reads a <code>long</code> value from this stream. The value must have been
	* written via {@link IDataOutputStream#writeLong(long)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public long readLong()throws java.io.IOException;

	/**
	* Reads a <code>float</code> value from this stream. The value must have been
	* written via {@link IDataOutputStream#writeFloat(float)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public float readFloat()throws java.io.IOException;

	/**
	* Reads a <code>double</code> value from this stream. The value must have been
	* written via
{@link IDataOutputStream#writeDouble(double)}.
	*
	* @return		the value read
	* @throws		java.io.IOException if some other I/O problem occurs
	**/
	 public double readDouble()throws java.io.IOException;

	/**
	* Reads a <code>String</code> from this stream. The value must have been written
	* via {@link IDataOutputStream#writeUTF(String)}.
	*
	**/
	 public java.lang.String readUTF()throws java.io.IOException;

	/**
	* Closes this stream.
	*
	* @throws		IOException if the stream cannot be closed properly.
	**/
	 public void close()throws java.io.IOException;

}