package com.ulcjava.base.shared;


	/**
	* Defines operations for writing primitive values and objects in a structured
	* format to some underlying output stream. This interface is
similar to {@link
	* java.io.DataOutput}, except that the byte-level representation of values
	* written via this interface is deliberately
left unspecified to allow for
	* future optimizations. The ULC communications layer decorates the raw
	* transportchannel between client and
server with an implementation of this
	* interface to relieve the marshalling code in ULC half objects from the burden
	* of encoding request
and state data at the byte level.
<p>
</p>
Data written
	* using this interface can only be read back via the {@link IDataInputStream}
	* interface. For each data element written by a
<code>write</code><em>Type</em>
	* method, the reader must invoke the corresponding
	* <code>read</code><em>Type</em> method. There
is no automatic conversion of
	* types. The results of a <code>read</code><em>Type</em> invocation with a type
	* different from the
actual data type of the next data element in the stream
	* areundefined, as are the results of all subsequent read operations on
	* the
stream.
</p>
<p>
</p>
<strong>Instances of this interface are not
	* thread-safe.</strong> Clients must not share instance references among
	* threadsand should in
fact not retain references beyond the scope of the
	* methodto which the reference was passed. Instances may refer to thread-local
	* or
otherwise volatile state and will behave in an unspecified fashion if
	* accessed outside the method invocation to which the reference
	* was
provided.
</p>
<p>
</p>
	*
	* @ulc.extension		
	**/
 public interface IDataOutputStream
{


	/**
	* Writes a <code>boolean</code> value to this stream. The value must be read
	* backvia
{@link com.ulcjava.base.shared.IObjectInputStream#readBoolean()}.
	*
	* @param value 		 the value to write
	**/
	 public void writeBoolean(boolean value)throws java.io.IOException;

	/**
	* Writes a <code>byte</code> value to this stream. The value must be read back
	* via
{@link com.ulcjava.base.shared.IObjectInputStream#readByte()}.
	*
	* @param value 		 the value to write
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeByte(byte value)throws java.io.IOException;

	/**
	* Writes a <code>char</code> value to this stream. The value must be read back
	* via
{@link
	* com.ulcjava.base.shared.IObjectInputStream#readChar()}.
<p>
</p>
The current
	* ULC implementations of this interface code characters in the range 0 to 127
	* (decimal) more efficient than other
characters.
</p>
	*
	* @param value 		 the value to write
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeChar(char value)throws java.io.IOException;

	/**
	* Writes a <code>short</code> value to this stream. The value must be read back
	* via
{@link com.ulcjava.base.shared.IObjectInputStream#readShort()}.
	*
	* @param value 		 the value to write
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeShort(short value)throws java.io.IOException;

	/**
	* Writes an <code>int</code> value to this stream. The value must be read back
	* via
{@link
	* com.ulcjava.base.shared.IObjectInputStream#readInt()}.
<p>
</p>
Thecurrent
	* ULCimplementations of this interface code values in the range 0 to 63
	* (decimal) more efficient than other values.
</p>
	*
	* @param value 		 the value to write
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeInt(int value)throws java.io.IOException;

	/**
	* Writes a <code>long</code> value to this stream. The value must be read back
	* via
{@link com.ulcjava.base.shared.IObjectInputStream#readLong()}.
	*
	* @param value 		 the value to write
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeLong(long value)throws java.io.IOException;

	/**
	* Writes a <code>float</code> value to this stream. The value must be read back
	* via
{@link com.ulcjava.base.shared.IObjectInputStream#readFloat()}.
	*
	* @param value 		 the value to write
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeFloat(float value)throws java.io.IOException;

	/**
	* Writes a <code>double</code> value to this stream. The value must be read back
	* via
{@link com.ulcjava.base.shared.IObjectInputStream#readDouble()}.
	*
	* @param value 		 the value to write
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeDouble(double value)throws java.io.IOException;

	/**
	* Writes a <code>String</code> to this stream. The value must be read via {@link
	* IDataInputStream#readUTF()}.
	*
	* @throws		IOException if the value cannot be written properly.
	**/
	 public void writeUTF(java.lang.String value)throws java.io.IOException;

	/**
	* Flushes this output stream and forces any buffered output bytes to be written
	* out.
	*
	* @throws		IOException if the stream cannot be flushed properly.
	**/
	 public void flush()throws java.io.IOException;

	/**
	* Closes this stream.
	*
	* @throws		IOException if the stream cannot be closed properly.
	**/
	 public void close()throws java.io.IOException;

}