package com.ulcjava.base.shared;


	/**
	* Defines an operation for reading objects from a stream that has been written
	* using {@link IObjectOutputStream}. The reading half of the
ULC marshalling
	* code interacts with the underlying transport channel via an instance of this
	* interface.
<p>
</p>
Note that data elements written via
	* <code>IObjectOutputStream</code> must be read back in the same sequence and
	* with the same types
that they were written. In other words, for each
	* <code>write</code><em>Type</em> call issued against the stream, there must be
	* a
corresponding <code>read</code><em>Type</em> call specifying the same type.
	* The results of a <code>read</code><em>Type</em>
invocation with a type
	* different from the actual data type of the next data element in the stream
	* areundefined, as are the results of
all subsequent read operations on the
	* stream.
</p>
<p>
</p>
The method in this interface throws an
	* <code>IOException</code> if the stream is found corrupted in some fashion,
	* forexample if the
control information in the stream is inconsistent or if the
	* implementation can determine with certainty that the data type requested by
	* a
read operation does not match the next data element in the
	* stream.
<p>
</p>
<strong>Instances of this interface are not
	* thread-safe.</strong> Clients must not share instance references among
	* threadsand should in
fact not retain references beyond the scope of the
	* methodto which the reference was passed. Instances may refer to thread-local
	* or
otherwise volatile state and will behave in an unspecified fashion if
	* accessed outside the method invocation to which the reference
	* was
provided.
</p>
	*
	* @ulc.extension		
	**/
 public interface IObjectInputStream extends com.ulcjava.base.shared.IDataInputStream
{


	/**
	* Reads an object from this stream. The object must have been written via {@link
	* IObjectOutputStream#writeObject(Object)}.
	*
	* @return		the value read
	* @throws		IOException if some I/O problem occurs.
	**/
	 public java.lang.Object readObject()throws java.io.IOException;

}