package com.ulcjava.base.shared;


	/**
	* Classes implementing this interface are called coders. They define strategies
	* on how instances of a certain class should be serialized to
a ULC output
	* stream ({@link IObjectOutputStream}) or deserialized from a ULC input stream
	* ({@link IObjectInputStream}), respectively.
Using an instance of {@link
	* CoderRegistry} a coder can be associated with a class whose instances it
	* should serialize or deserialize,
respectively.
<p>
</p>
Right before a coder
	* serializes an object <code>o</code> of a given class, it writes the so-called
	* peer class name into the ULC output
stream. When reading the written stream
	* using a corresponding ULC input stream, the coded peer class name is used in
	* order to determine,
what coder should be used to deserialize the data of
	* <code>o</code> back into an object <code>p</code>. The peer class name is
	* the
name of the class of <code>p</code>. It may be different from the name of
	* the class of <code>o</code> and therefore, the type of a
marshalled object
	* maychange during the serialization/deserialization process.
<p>
</p>
When
	* reading a written ULC stream via a ULC input stream, the peer class name is
	* used to lookup an appropriate coder in a coder registry
that is associated
	* with the ULC input stream. An appropriate coder registry is provided by ULC
	* when creating the ULC input stream.
Consequently, there are two coders
	* <code>c1</code> and <code>c2</code> in play, when marshalling an object:
	* <code>c1</code>
serializes the object and <code>c2</code> deserializes the
	* object. (Note though, that these two coders might well be identical.) It
	* is
crucial for the coding/decoding mechanism that the two coders agree on the
	* way that object state is written to the stream and read from
the stream. This
	* way is given by the order of <code>IObjectOutputStream.writeX(...)</code>
	* calls performed inside the
{@link #writeObject(IObjectOutputStream,Object)}
	* implementation of coder <code>c1</code> and
	* the
<code>IObjectInputStream.readX(...)</code> calls performed by the {@link
	* #readObject(IObjectInputStream)} implementation of coder
<code>c2</code>.
	*
	* @ulc.extension		
	* @see		IObjectInputStream
	* @see		IObjectOutputStream
	* @see		CoderRegistry
	**/
 public interface IStreamCoder
{


	/**
	* Returns the peer class name of the class for which there will be coder
	* instance<code>c2</code> registered, where <code>c2</code>
is in charge of
	* deserializing the object state written via this coder (<code>c1</code>).
	* <code>c2</code> is expected to be
registered at a coder registry, which is
	* used by the corresponding deserializing ULC input stream. It is assumed
	* (although not
required) that the resulting deserialized object is an instance
	* of the class referenced by the returned peer class name.
	*
	* @return		the peer class name
	* @see		IObjectInputStream#readObject()
	* @see		IObjectOutputStream#writeObject(Object)
	* @see		CoderRegistry
	**/
	 public java.lang.String getPeerClassName();

	/**
	* Writes the state of an object into a ULC output stream. Implement this method
	* in order to provide a custom way to serialize the state
of an object. The
	* object is assumed to be of the class that this coder is designed for. Use
	* the
<code>IObjectOutputStream.writeX(...)</code> methods to do so.)
	*
	* @param out 		 the ULC output stream, to which the state is to be written
	* @param data 		 the object that is to be serialized
	* @throws		NullPointerException if any argument is null
	* @throws		ClassCastException if <code>data</code> is not an instance of the class that this coder is designed for
	**/
	 public void writeObject(com.ulcjava.base.shared.IObjectOutputStream out, java.lang.Object data)throws java.io.IOException;

	/**
	* Reads the state of an object from a ULC input stream. Implement this method in
	* order to provide a custom way to deserialize the state
of an object. The
	* returned object is assumed to be of the class that this coder is designed for.
	*
	* @param in 		 the ULC input stream, from which to read the object
	* @return		the deserialized object
	* @throws		IOException if reading the state of the object from stream failed
	**/
	 public java.lang.Object readObject(com.ulcjava.base.shared.IObjectInputStream in)throws java.io.IOException;

}