package com.ulcjava.base.shared.logging;


	/**
	* A <code>Logger</code> object is used to log messages for a specific system or
	* application component. <code>Logger</code>s are
normally named, using a
	* hierarchical dot-separated namespace. Logger names can be arbitrary strings,
	* but they should normally be based on
the package name or class name of the
	* logged component, such as <code>java.net</code> or <code>javax.swing</code>.
	* In addition it is
possible to create "anonymous" Loggers that are not stored
	* in the <code>Logger</code> namespace.
<p>
</p>
<code>Logger</code> objects
	* maybe obtained by calls on one of the <code>getLogger()</code> factory
	* methods. These will either create
a new <code>Logger</code> or return a
	* suitable existing <code>Logger</code>.
	*
	* @ulc.application		
	**/
 public  abstract class Logger extends java.lang.Object
{


	/**
	* Returns the logger for a named subsystem.
	*
	* @param name 		 the name of the logger
	* @return		a suitable logger
	**/
	 public  synchronized  static com.ulcjava.base.shared.logging.Logger getLogger(java.lang.String name)
	{
		return null;
	}


	/**
	* Returns an unnamed logger.
	*
	* @return		a suitable logger
	**/
	 public  synchronized  static com.ulcjava.base.shared.logging.Logger getAnonymousLogger()
	{
		return null;
	}


	/**
	* Logs a method entry.
	*
	* @param className 		 name of class that issued the logging request
	* @param methodName 		 name of method that is being entered
	**/
	 public  abstract void entering(java.lang.String className, java.lang.String methodName);

	/**
	* Logs a method entry, with one parameter.
	*
	* @param className 		 name of class that issued the logging request
	* @param methodName 		 name of method that is being entered
	* @param param 		 parameter to the method being entered
	**/
	 public  abstract void entering(java.lang.String className, java.lang.String methodName, java.lang.Object param);

	/**
	* Logs a method entry, with an array of parameters.
	*
	* @param className 		 name of class that issued the logging request
	* @param methodName 		 name of method that is being entered
	* @param params 		 array of parameters to the method being entered
	**/
	 public  abstract void entering(java.lang.String className, java.lang.String methodName, java.lang.Object[] params);

	/**
	* Logs a method return.
	*
	* @param className 		 name of class that issued the logging request
	* @param methodName 		 name of the method
	**/
	 public  abstract void exiting(java.lang.String className, java.lang.String methodName);

	/**
	* Logs a method return, with result object.
	*
	* @param className 		 name of class that issued the logging request
	* @param methodName 		 name of the method
	* @param result 		 object that is being returned
	**/
	 public  abstract void exiting(java.lang.String className, java.lang.String methodName, java.lang.Object result);

	/**
	* Logs throwing an exception.
	*
	* @param className 		 name of class that issued the logging request
	* @param methodName 		 name of the method.
	* @param thrown 		 throwable that is being thrown.
	**/
	 public  abstract void throwing(java.lang.String className, java.lang.String methodName, java.lang.Throwable thrown);

	/**
	* Logs a severe message.
	*
	* @param msg 		 log message
	**/
	 public  abstract void severe(java.lang.String msg);

	/**
	* Logs a warning message.
	*
	* @param msg 		 log message
	**/
	 public  abstract void warning(java.lang.String msg);

	/**
	* Logs an info message.
	*
	* @param msg 		 log message
	**/
	 public  abstract void info(java.lang.String msg);

	/**
	* Logs a config message.
	*
	* @param msg 		 log message
	**/
	 public  abstract void config(java.lang.String msg);

	/**
	* Logs a fine message.
	*
	* @param msg 		 log message
	**/
	 public  abstract void fine(java.lang.String msg);

	/**
	* Logs a finer message.
	*
	* @param msg 		 log message
	**/
	 public  abstract void finer(java.lang.String msg);

	/**
	* Logs a finest message.
	*
	* @param msg 		 log message
	**/
	 public  abstract void finest(java.lang.String msg);

	/**
	* Logs a message with the specified level.
	*
	* @param level 		 the level of the message
	* @param msg 		 the message
	**/
	 public  abstract void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg);

	/**
	* Logs a message with the specified level and one parameter.
	*
	* @param level 		 the level of the message
	* @param msg 		 the message
	* @param param1 		 the message parameter
	**/
	 public  abstract void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg, java.lang.Object param1);

	/**
	* Logs a message with the specified level and several parameter.
	*
	* @param level 		 the level of the message
	* @param msg 		 the message
	* @param params 		 the message parameters
	**/
	 public  abstract void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg, java.lang.Object[] params);

	/**
	* Logs a message with the specified level and a throwable.
	*
	* @param level 		 the level of the message
	* @param msg 		 the message
	* @param thrown 		 the message throwable
	**/
	 public  abstract void log(com.ulcjava.base.shared.logging.Level level, java.lang.String msg, java.lang.Throwable thrown);

	/**
	* Logs a message with the specified level, class name, method name, message, and
	* parameters.
	*
	* @param level 		 the level to log
	* @param className 		 the class name to log
	* @param methodName 		 the method name to log
	* @param msg 		 the message to log
	* @param params 		 the parameters to log
	**/
	 public  abstract void log(com.ulcjava.base.shared.logging.Level level, java.lang.String className, java.lang.String methodName, java.lang.String msg, java.lang.Object[] params);

	/**
	* Returns the log level of this logger.
	*
	* @return		the log level of this logger
	**/
	 public  abstract com.ulcjava.base.shared.logging.Level getLevel();

	/**
	* Sets the log level for this logger.
	*
	* @param level 		 the log level for this logger
	**/
	 public  abstract void setLevel(com.ulcjava.base.shared.logging.Level level);

}