package com.ulcjava.base.shared.logging;


	/**
	* A log config provider, which returns a log config instance, whose setting
	* depends on a properties file named
<code>ulclog.properties</code>. The {@link
	* PropertiesLogConfigProvider} instance tries to load the properties file via
	* its classloader
using
	* <code>getClass().getResourceAsStream(...)</code>.
<p>
</p>
Two optional
	* properties are read from the properties file:
<ul>
<li><code>log-level</code>
	* defines the log level for the resulting default log config
	* object.
<li><code>message-format</code> defines the message format for the
	* resulting default log config object.
</ul>
If the properties file cannot be
	* found or if a corresponding property is not set in the file, a default value
	* is used such as given by
{@link
	* DefaultSimpleLogConfigProvider#createLogConfig()}.
	*
	* @see		ISimpleLogConfigProvider
	* @see		SimpleLogConfig
	* @ulc.extension		
	**/
 public class PropertiesLogConfigProvider extends com.ulcjava.base.shared.logging.SimpleLogManager.DefaultSimpleLogConfigProvider
{

	/**
	* The name of the log properties file (<code>/ulclog.properties</code>).
	*
	**/
	 public  final  static java.lang.String LOG_PROPERTIES_FILE_NAME = null;

	/**
	* The log-level property of the properties file (<code>log-level</code>).
	*
	**/
	 public  final  static java.lang.String LOG_LEVEL_KEY = null;

	/**
	* The message format property of the properties file
	* (<code>message-format</code>).
	*
	**/
	 public  final  static java.lang.String MESSAGE_FORMAT_KEY = null;


	/**
	* Creates the default log config instance. The latter is used whenever the log
	* config cannot be obtained from the container service
(which must be bound to
	* the current ULC session).
	*
	**/
	 protected com.ulcjava.base.shared.logging.SimpleLogConfig createLogConfig()
	{
		return null;
	}


}