/*
 * Copyright (c) 2000-2009 Canoo Engineering AG, Switzerland.
 */

package com.ulcjava.environment.applet.client;

import netscape.javascript.JSObject;

import com.ulcjava.base.client.IConnector;
import com.ulcjava.base.client.ISessionStateListener;
import com.ulcjava.base.client.launcher.ApplicationConfigurationBasedClientConfiguration;
import com.ulcjava.base.client.launcher.LauncherUtilities;
import com.ulcjava.base.client.launcher.ServiceFactory;
import com.ulcjava.base.shared.IClientConfiguration;
import com.ulcjava.base.shared.internal.IllegalArgumentException;
import com.ulcjava.base.shared.logging.Level;
import com.ulcjava.base.shared.logging.LogManager;
import com.ulcjava.base.shared.logging.Logger;
import com.ulcjava.base.shared.logging.SimpleLogManager;
import com.ulcjava.base.shared.streamcoder.CoderConfiguration;
import com.ulcjava.container.servlet.client.AppletRequestPropertyStore;
import com.ulcjava.container.servlet.client.ServletConnector;

import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.SwingUtilities;

/**
 * @ulc.application
 */
public class DefaultAppletLauncher extends AbstractAppletLauncher {
    private IClientConfiguration fClientConfiguration;
    private static final Logger LOG = Logger.getLogger(DefaultAppletLauncher.class.getName());
    
    /**
     * @ulc.extension
     */
    public DefaultAppletLauncher() {
    }
    
    /**
     * @ulc.extension
     */
    protected IConnector createConnector() {
        String urlString = getUrlString();
        int keepAliveInterval = getKeepAliveInterval();
        String dataStreamProviderclassName = getDataStreamProviderClassName();
        String carrierStreamProviderClassName = getCarrierStreamProviderClassName();
        String clientRegistryProviderClassName = getClientCoderRegistryProviderClassName();
        
        try {
            return new ServletConnector(new AppletRequestPropertyStore(), new URL(urlString), keepAliveInterval,
                    dataStreamProviderclassName, carrierStreamProviderClassName, clientRegistryProviderClassName, getClientConfiguration());
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + urlString, e);
        }
    }
    
    /**
     * @ulc.extension
     */
    public void init() {
        super.init();
        try {
            fClientConfiguration = new ApplicationConfigurationBasedClientConfiguration(getUrlString());
        } catch (RuntimeException e1) {
            fClientConfiguration = new AppletBasedClientConfiguration();
        }
        String logLevel = getLogLevel();
        if (logLevel != null) {
            if (LogManager.getLogManager() instanceof SimpleLogManager) {
                SimpleLogManager simpleLogManager = (SimpleLogManager)LogManager.getLogManager();
                simpleLogManager.setLevel(Level.parse(logLevel));
            }
        }
        ServiceFactory.configureServices(getClientConfiguration());
    }
    
    public void start() {
        LauncherUtilities.setLookAndFeel(getClientConfiguration());
        SwingUtilities.updateComponentTreeUI(this.getRootPane());
        super.start();
        String functionToCall = getParameter(LauncherUtilities.CALL_SCRIPT_KEY);
        if (functionToCall != null) {
            
            try {
                JSObject jso = JSObject.getWindow(this);
                jso.call(functionToCall, new Object[0]);
            } catch (Throwable ignored) {
                LOG.log(Level.SEVERE, "Calling " + functionToCall + " failed:", ignored);
            }
        }
    }
    
    protected ISessionStateListener createSessionStateListener() {
        return LauncherUtilities.createSessionStateListener(getClientConfiguration());
    }
    
    protected String getUrlString() {
        return getParameter(LauncherUtilities.URL_STRING_KEY);
    }
    
    protected int getKeepAliveInterval() {
        return getClientConfiguration().getKeepAliveInterval().intValue();
    }
    
    protected String getLogLevel() {
        return getClientConfiguration().getClientLogLevel();
    }
    
    protected IClientConfiguration getClientConfiguration() {
        return fClientConfiguration;
    }
    
    protected String getDataStreamProviderClassName() {
        return getClientConfiguration().getDataStreamProviderClassName();
    }
    
    protected String getCarrierStreamProviderClassName() {
        return getClientConfiguration().getCarrierStreamProviderClassName();
    }
    
    protected String getClientCoderRegistryProviderClassName() {
        return getClientConfiguration().getClientCoderRegistryProviderClassName();
    }
    
    /**
     * @ulc.extension
     */
    public String[][] getParameterInfo() {
        String[][] superParameterInfo = super.getParameterInfo();
        String[][] result = new String[superParameterInfo.length + 5][];
        System.arraycopy(superParameterInfo, 0, result, 0, superParameterInfo.length);
        String deprecatedMessage = " (This parameter is deprecated - use the ULCApplicationConfiguration.xml file instead)";
        result[superParameterInfo.length] = new String[] {LauncherUtilities.URL_STRING_KEY, "url",
                "url identifying the application to connect to" + deprecatedMessage};
        result[superParameterInfo.length + 1] = new String[] {LauncherUtilities.KEEP_ALIVE_INTERVAL_KEY, ">0",
                "interval in seconds to post keep alive requests" + deprecatedMessage};
        result[superParameterInfo.length + 2] = new String[] {LauncherUtilities.LOG_LEVEL_KEY, "level",
                "log level for Logger implementation in SimpleLogManager" + deprecatedMessage};
        result[superParameterInfo.length + 3] = new String[] {LauncherUtilities.CARRIER_STREAM_PROVIDER_KEY, "class name",
                "the carrier stream provider" + deprecatedMessage};
        result[superParameterInfo.length + 4] = new String[] {LauncherUtilities.CLIENT_CODER_REGISTRY_PROVIDER_KEY, "class name",
                "the client-side coder registry provider" + deprecatedMessage};
        
        return result;
    }
    
    
    private class AppletBasedClientConfiguration implements IClientConfiguration {
        
        public String getBrowserServiceClassName() {
            return null;
        }
        
        public String getCarrierStreamProviderClassName() {
            return getParameter(LauncherUtilities.CARRIER_STREAM_PROVIDER_KEY);
        }
        
        public String getClientCoderRegistryProviderClassName() {
            return getParameter(LauncherUtilities.CLIENT_CODER_REGISTRY_PROVIDER_KEY);
        }
        
        public String getDataStreamProviderClassName() {
            return getParameter(LauncherUtilities.DATA_STREAM_PROVIDER_KEY);
        }
        
        public String getClientLogLevel() {
            return getParameter(LauncherUtilities.LOG_LEVEL_KEY);
        }
        
        public String getFileServiceClassName() {
            return null;
        }
        
        public Integer getKeepAliveInterval() {
            try {
                String keepAliveIntervalValue = getParameter(LauncherUtilities.KEEP_ALIVE_INTERVAL_KEY);
                if (keepAliveIntervalValue == null) {
                    return new Integer(LauncherUtilities.DEFAULT_KEEP_ALIVE_INTERVAL);
                }
                return new Integer(keepAliveIntervalValue);
            } catch (NumberFormatException e) {
                throw new IllegalArgumentException("Parameter '" + LauncherUtilities.KEEP_ALIVE_INTERVAL_KEY + "' must be an integer.");
            }
        }
        
        public String getLookAndFeel() {
            return null;
        }
        
        public String getMessageServiceClassName() {
            return null;
        }
        
        public String getClientSessionErrorHandlerClassName() {
            return null;
        }
        
        public CoderConfiguration[] getClientCoderConfigurations() {
            return null;
        }
        
    }
}
